//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Vote;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Xml.Linq;
using SpaceBuilder.Club;

namespace SpaceBuilder.Vote.Modules
{
    /// <summary>
    /// VoteصĶ̬
    /// </summary>
    public class DisposeActivityForVote : IVoteModule
    {

        #region IVoteModule Ա

        public void Init(VoteEventManager em, XElement xElement)
        {
            em.AfterVoteThreadChange += new VoteThreadEventHandler(em_AfterVoteThreadChange);
            em.AfterVoteCommentChange += new VoteCommentEventHandler(em_AfterVoteCommentChange);
            em.AfterVoteChange += new VoteEventHandler(em_AfterVoteChange);
        }

        void em_AfterVoteThreadChange(VoteThread voteThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewVoteThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(voteThread.UserID, false);

                if (user == null)
                    return;

                #region ˶̬
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewVoteThread", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetVoteNameWithHyperlink(voteThread));
                userActivity.IsPublic = voteThread.PrivacyStatus == PrivacyStatuses.Public ? true : false;

                userActivity.RelativeItemID = voteThread.ThreadID;
                userActivity.RelativeItemName = voteThread.Subject;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region Ѷ̬
                if (voteThread.PrivacyStatus == PrivacyStatuses.Public)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //жûǷ͸ Ѷ̬Ŀ

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.RelativeItemID = voteThread.ThreadID;
                        friendActivity.RelativeItemName = voteThread.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion

                #region Ⱥ鶯̬
                if (voteThread.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                {
                    ClubActivity clubActivity = new ClubActivity();
                    clubActivity.ApplicationID = ApplicationIDs.Instance().Vote();
                    clubActivity.ClubID = voteThread.OwnerID;
                    clubActivity.LeadingActorUserID = user.UserID;
                    clubActivity.LeadingActor = user.DisplayName;
                    clubActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewClubVoteThread", user.Language, e.ApplicationID), GetVoteNameWithHyperlink(voteThread));
                    clubActivity.Body = userActivity.Body;
                    clubActivity.RelativeItemID = voteThread.ThreadID;
                    clubActivity.RelativeItemName = voteThread.Subject;
                    ClubActivities.CreateClubActivity(clubActivity);
                    if (clubActivity.ActivityID > 0)
                    {
                        PagingDataSet<ClubMember> members = ClubMembers.GetMembers(clubActivity.ClubID, null, null, ValueHelper.GetSqlMaxInt(), 1, false);
                        List<int> memberIDs = new List<int>();
                        foreach (ClubMember member in members.Records)
                        {
                            memberIDs.Add(member.UserID);
                        }
                        ClubActivities.SendToClubMembers(clubActivity.ActivityID, ApplicationIDs.Instance().Vote(), memberIDs);
                    }
                }

                #endregion
            }
        }

        void em_AfterVoteChange(IList<VoteRecord> records, VoteThread voteThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().JoinVoteThread();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                if (records == null || records.Count == 0)
                    return;
                //û̬¼
                if (records[0].IsAnonymousVote)
                    return;
                int userID = records[0].UserID;
                User user = Users.GetUser(userID, false);

                if (user == null)
                    return;

                #region ˶̬
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_JoinVoteThread", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetVoteNameWithHyperlink(voteThread));

                userActivity.IsPublic = voteThread.PrivacyStatus == PrivacyStatuses.Public ? true : false;

                userActivity.RelativeItemID = voteThread.ThreadID;
                userActivity.RelativeItemName = voteThread.Subject;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region Ѷ̬
                if (voteThread.PrivacyStatus == PrivacyStatuses.Public)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //жûǷ͸ Ѷ̬Ŀ

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.RelativeItemID = voteThread.ThreadID;
                        friendActivity.RelativeItemName = voteThread.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        void em_AfterVoteCommentChange(VoteComment voteComment, VoteThread voteThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                string itemKey = ActivityItemKeys.Instance().NewVoteComment();
                ActivityItem activityItem = Activities.GetActivityItem(itemKey);
                if (activityItem == null)
                    return;
                User user = Users.GetUser(voteComment.UserID, false);

                if (user == null)
                    return;

                #region ˶̬
                UserActivity userActivity = new UserActivity();
                userActivity.ApplicationID = activityItem.ApplicationID;
                userActivity.ActivityItemID = activityItem.ItemID;
                userActivity.LeadingActorUserID = user.UserID;
                userActivity.LeadingActor = user.DisplayName;
                userActivity.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Activity_NewVoteComment", user.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(user,true), GetVoteNameWithHyperlink(voteThread));
                userActivity.IsPublic = voteThread.PrivacyStatus == PrivacyStatuses.Public ? true : false;

                userActivity.RelativeItemID = voteThread.ThreadID;
                userActivity.RelativeItemName = voteThread.Subject;

                Activities.CreateUserActivity(userActivity);
                #endregion

                #region Ѷ̬
                if (voteThread.PrivacyStatus == PrivacyStatuses.Public)
                {
                    UserActivitySettings userActivitySettings = Activities.GetUserActivitySettings(user.UserID, false);
                    //жûǷ͸ Ѷ̬Ŀ

                    if (userActivitySettings.IsAllowedInActivityItemsOfSending(itemKey))
                    {
                        FriendActivity friendActivity = new FriendActivity();
                        friendActivity.ApplicationID = activityItem.ApplicationID;
                        friendActivity.ActivityItemID = activityItem.ItemID;
                        friendActivity.LeadingActorUserID = user.UserID;
                        friendActivity.LeadingActor = user.DisplayName;
                        friendActivity.Subject = userActivity.Subject;

                        friendActivity.RelativeItemID = voteThread.ThreadID;
                        friendActivity.RelativeItemName = voteThread.Subject;

                        List<int> receiverUserIDs = Activities.GetFriendActivityReceiverUserIDsFromFriends(user, itemKey);
                        Activities.CreateFriendActivity(friendActivity, receiverUserIDs);
                    }
                }
                #endregion
            }
        }

        #endregion

        /// <summary>
        /// ȡӵͶƱƵhtml
        /// </summary>
        private static string GetVoteNameWithHyperlink(VoteThread voteThread)
        {
            string voteThreadUrl = SiteUrls.Instance().ShowVoteThread(voteThread.ThreadID);
            if (voteThread.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                voteThreadUrl = SiteUrls.Instance().ShowClubVoteThread(ClubID2ClubNameDictionary.GetClubDomainName(voteThread.OwnerID), voteThread.ThreadID);
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, voteThreadUrl, voteThread.Subject);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;
    }
}