﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Vote;
using SpaceBuilder.Common.Mail;
using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using SpaceBuilder.Club;

namespace SpaceBuilder.Vote.Modules
{
    /// <summary>
    /// 处理与Vote相关的动态、通知
    /// </summary>
    public class DisposeNoticeForVote : IVoteModule
    {
        #region IVoteModule 成员

        public void Init(VoteEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterVoteCommentChange += new VoteCommentEventHandler(em_AfterVoteCommentChange);
        }

        void em_AfterVoteCommentChange(VoteComment voteComment, VoteThread voteThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create)
            {
                if (voteComment.UserID == voteThread.UserID)
                    return;
                //通知接收人
                User toUser = null;
                if (voteComment.ParentID > 0)
                {
                    if (voteComment.ParentUserID > 0)
                        toUser = Users.GetUser(voteComment.ParentUserID, false);
                }
                else
                    toUser = Users.GetUser(voteThread.UserID, false);
                if (toUser == null)
                    return;
                    
                string itemKey = NoticeItemKeys.Instance().NewVoteComment();
                NoticeItem noticeItem = NoticeSettingsManager.GetNoticeItem(itemKey);
                if (noticeItem == null)
                    return;
                NoticeRecord record = new NoticeRecord();
                record.UserID = toUser.UserID;
                record.Receiver = toUser.DisplayName;
                record.ApplicationID = ApplicationIDs.Instance().Vote();
                record.NoticeItemID = noticeItem.ItemID;
                record.NoticeItemKey = noticeItem.ItemKey;
                record.LeadingActorUserID = voteComment.UserID;
                record.LeadingActor = voteComment.Author;
                record.LeadingActorUrl = SiteUrls.Instance().UserChannelHome(record.LeadingActorUserID, ApplicationIDs.Instance().Vote());
                record.RelativeItemID = voteThread.ThreadID;
                record.RelativeItemName = voteThread.Subject;
                record.Subject = string.Format(ResourceManager.GetString("Title_Pattern_Notice_NewVoteComment", toUser.Language, e.ApplicationID), SPBHtmlHelper.Instance().UserDisplayNameLink(voteComment.UserID, voteComment.Author, true), GetVoteNameWithHyperlink(voteThread));
                record.RelativeItemUrl = SiteUrls.Instance().ShowVoteThread(voteThread.ThreadID);
                NoticeProcessorFactory.Instance().ProcessNotice(record);
            }
        }

        #endregion
        /// <summary>
        /// 获取带链接的投票名称的html代码
        /// </summary>
        private static string GetVoteNameWithHyperlink(VoteThread voteThread)
        {
            string voteThreadUrl = SiteUrls.Instance().ShowVoteThread(voteThread.ThreadID);
            if (voteThread.PresentAreaID == PresentAreaIDs.Instance().ClubDomain())
                voteThreadUrl = SiteUrls.Instance().ShowClubVoteThread(ClubID2ClubNameDictionary.GetClubDomainName(voteThread.OwnerID), voteThread.ThreadID);
            return string.Format("<a {0} href=\"{1}\">{2}</a>", HyperlinkTargetOfUserActivity, voteThreadUrl, voteThread.Subject);
        }

        private static readonly string HyperlinkTargetOfUserActivity = SiteSettingsManager.GetSiteSettings().OpenNewWindowInUserActivity ? "target=\"_blank\"" : string.Empty;

    }
}