//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;

namespace SpaceBuilder.Vote.Modules
{
    /// <summary>
    /// ƼϢصĻ
    /// </summary>
    public class DisposePointForReCommendedVote : IServiceModule
    {
        #region IServiceModule Ա

        public void Init(ServiceEventManager gem, System.Xml.Linq.XElement node)
        {
            if (SiteSettingsManager.GetSiteSettings().EnablePoints)
            {
                gem.RecommendedItemChange += new RecommendedItemEventHandler(gem_RecommendedItemChange);
            }
        }
        #endregion

        void gem_RecommendedItemChange(RecommendedItem commendedItem, GlobalEventArgs e)
        {
            if ((e.ApplicationID == ApplicationIDs.Instance().Vote()) && (e.State == ObjectState.Create))
            {
                string userPointRecordDescription = string.Empty;
                string itemKey = string.Empty;
                UserPointItemRole role = null;
                User user = Users.GetUser(commendedItem.AuthorUserID, false);
                if (user == null)
                    return;

                itemKey = UserPointItemKeys.Instance().RecommendedVoteThread();
                role = Points.GetUserPointItemRole(itemKey);
                if (role == null)
                    return;

                userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_RecommendedVoteThread", user.Language, e.ApplicationID), commendedItem.ItemName);
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, commendedItem.AuthorUserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);
                Points.CreateUserPointRecords(records);
            }
        }
    }
}