//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Text;

using SpaceBuilder.Common;
using SpaceBuilder.Utils;

namespace SpaceBuilder.Vote.Modules
{
    /// <summary>
    /// 벩صĻ
    /// </summary>
    public class DisposePointForVote : IVoteModule
    {
        #region IVoteModule Ա

        public void Init(VoteEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterPointChangeOfVoteThread += new PointChangeOfVoteThreadHandler(em_AfterPointChangeOfVoteThread);
            em.AfterVoteChange += new VoteEventHandler(em_AfterVoteChange);
            //em.AfterVoteCommentChange += new VoteCommentEventHandler(em_AfterVoteCommentChange);
            //em.AfterVoteThreadChange += new VoteThreadEventHandler(em_AfterVoteThreadChange);
            em.AfterPointChangeOfVoteComment += new PointChangeOfVoteCommentHandler(em_AfterPointChangeOfVoteComment);
        }

        void em_AfterPointChangeOfVoteComment(VoteComment comment, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Delete)
            {
                UserPointItemRole role = null;
                User user = Users.GetUser(comment.UserID, false);
                if (user == null)
                    return;
                VoteThread voteThread = VoteThreads.GetThread(comment.ThreadID, false);
                string userPointRecordDescription = string.Empty;
                if (userPointDirection == UserPointDirection.Input)
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateVoteComment());
                    if (e.State == ObjectState.Create)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateVoteComment", user.Language, e.ApplicationID), voteThread.Subject);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_VoteCommentAuditingSuccess", user.Language, e.ApplicationID), voteThread.Subject);

                }
                else
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteVoteComment());
                    if (e.State == ObjectState.Delete)
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteVoteComment", user.Language, e.ApplicationID), voteThread.Subject);
                    else
                        userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_VoteCommentAuditingFail", user.Language, e.ApplicationID), voteThread.Subject);

                }

                if (role == null)
                    return;
                List<UserPointRecord> records = Points.PopulateUserPointRecords(role, comment.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(records);
            }
        }

        void em_AfterPointChangeOfVoteThread(VoteThread voteThread, GlobalEventArgs e, UserPointDirection userPointDirection)
        {
            UserPointItemRole role = null;
            string userPointRecordDescription = string.Empty;
            User user = Users.GetUser(voteThread.UserID, false);
            if (user == null)
                return;

            if (userPointDirection == UserPointDirection.Input)
            {

                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateVoteThread());
                if (e.State == ObjectState.Create)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateVoteThread", user.Language, ApplicationIDs.Instance().Vote()), voteThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_VoteThreadAuditingSuccess", user.Language, ApplicationIDs.Instance().Vote()), voteThread.Subject);
            }
            else
            {
                role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteFriend());
                if (e.State == ObjectState.Delete)
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteVoteThread", user.Language, ApplicationIDs.Instance().Vote()), voteThread.Subject);
                else
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_VoteThreadAuditingFail", user.Language, ApplicationIDs.Instance().Vote()), voteThread.Subject);
            }

            if (role == null)
                return;
            List<UserPointRecord> records = Points.PopulateUserPointRecords(role, voteThread.UserID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

            Points.CreateUserPointRecords(records);
        }

        //void em_AfterVoteThreadChange(VoteThread voteThread, GlobalEventArgs e)
        //{
        //    if (e.State == ObjectState.Create || e.State == ObjectState.Delete)
        //    {
        //        List<UserPointRecord> records = new List<UserPointRecord>();
        //        UserPointItemRole role = null;
        //        User user = Users.GetUser(voteThread.UserID, false);
        //        string userPointRecordDescription = string.Empty;

        //        if (e.State == ObjectState.Create)
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateVoteThread());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateVoteThread", user.Language, e.ApplicationID), voteThread.Subject);
        //        }
        //        else
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteVoteThread());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteVoteThread", user.Language, e.ApplicationID), voteThread.Subject);
        //        }

        //        PopulateUserPointRecords(records, role, voteThread.UserID, userPointRecordDescription);
        //        if (role != null)
        //        {
        //            Points.CreateUserPointRecords(records);
        //        }
        //    }
        //}

        //void em_AfterVoteCommentChange(VoteComment voteComment, VoteThread voteThread, GlobalEventArgs e)
        //{
        //    if (e.State == ObjectState.Create || e.State == ObjectState.Delete)
        //    {
        //        List<UserPointRecord> records = new List<UserPointRecord>();
        //        UserPointItemRole role = null;
        //        User user = Users.GetUser(voteComment.UserID, false);
        //        string userPointRecordDescription = string.Empty;
        //        if (e.State == ObjectState.Create)
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().CreateVoteComment());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_CreateVoteComment", user.Language, e.ApplicationID), voteThread.Subject);
        //        }
        //        else
        //        {
        //            role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().DeleteVoteComment());
        //            userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_DeleteVoteComment", user.Language, e.ApplicationID), voteThread.Subject);
        //        }

        //        PopulateUserPointRecords(records, role, voteComment.UserID, userPointRecordDescription);
        //        if (role != null)
        //        {
        //            Points.CreateUserPointRecords(records);
        //        }
        //    }
        //}

        void em_AfterVoteChange(IList<VoteRecord> records, VoteThread voteThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Delete)
            {
                if (records == null || records.Count == 0)
                    return;
                int userID = records[0].UserID;//ͶƱID

                UserPointItemRole role = null;
                string userPointRecordDescription = string.Empty;
                User user = Users.GetUser(userID, false);
                if (user == null)
                    return;
                if (e.State == ObjectState.Create)
                {
                    role = Points.GetUserPointItemRole(UserPointItemKeys.Instance().JoinVoteThread());
                    userPointRecordDescription = string.Format(ResourceManager.GetString("Title_Pattern_Point_JoinVoteThread", user.Language, e.ApplicationID), voteThread.Subject);
                }

                if (role == null)
                    return;

                List<UserPointRecord> userPointRecords = Points.PopulateUserPointRecords(role, userID, role.GetMultilingualItemName(Globals.GetCurrentUserLanguage()), userPointRecordDescription);

                Points.CreateUserPointRecords(userPointRecords);
            }
        }

        #endregion
    }
}
