﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;
using SpaceBuilder.Club;

namespace SpaceBuilder.Vote.Modules
{
    /// <summary>
    /// 删除群组时处理投票
    /// </summary>
    public class DisposeVoteForDeleteClub : IClubModule
    {
        #region IClubModule 成员

        public void Init(ClubEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.AfterClubChange += new ClubEventHandler(em_AfterClubChange);
        }

        void em_AfterClubChange(SpaceBuilder.Club.Club club, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Delete)
            {
                //todo:考虑表现区域
                VoteThreads.DeleteVoteForOwner(11, club.ClubID);
            }
        }

        #endregion
    }
}
