﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

namespace SpaceBuilder.Vote.Modules
{
    /// <summary>
    /// 删除用户时处理投票
    /// </summary>
    public class DisposeVoteForDeleteUser : IGlobalModule
    {

        #region IGlobalModule 成员

        public void Init(GlobalEventManager gem, System.Xml.Linq.XElement xElement)
        {
            gem.UserDelete += new UserDeleteEventHandler(gem_UserDelete);
            gem.UserDeleteAndReassignContent += new UserDeleteEventHandler(gem_UserDeleteAndReassignContent);
        }

        void gem_UserDeleteAndReassignContent(User user, string reassignUserName)
        {
            VoteThreads.DeleteUser(PresentAreaIDs.Instance().UserDomain(), user.UserID);
        }

        void gem_UserDelete(User user, string reassignUserName)
        {
            VoteThreads.DeleteUserAndReassignContent(user.UserID, reassignUserName);
        }

        #endregion
    }
}
