﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;

using SpaceBuilder.Utils;

namespace SpaceBuilder.Vote.Modules
{
    public class VoteCommentFormatting : IVoteModule
    {
        #region IVoteModule 成员

        public void Init(VoteEventManager em, System.Xml.Linq.XElement xElement)
        {
            em.BeforeVoteCommentChange += new VoteCommentEventHandler(em_BeforeVoteCommentChange);
        }

        void em_BeforeVoteCommentChange(VoteComment voteComment, VoteThread thread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                

                voteComment.Body = Formatter.FormatPlainTextComment(voteComment.Body);
                if (SPBConfig.Instance().EnableEmoticon)
                    voteComment.Body = EmotionManager.Instance().EmoticonTransforms(voteComment.Body);
            }
        }

        #endregion
    }
}
