﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SpaceBuilder.Common;


namespace SpaceBuilder.Vote.Modules
{
    public class VoteThreadFormatting : IVoteModule
    {
        #region IVoteModule 成员

        public void Init(VoteEventManager em, System.Xml.Linq.XElement node)
        {
            em.BeforeVoteThreadChange += new VoteThreadEventHandler(em_BeforeVoteThreadChange);
        }

        void em_BeforeVoteThreadChange(VoteThread voteThread, GlobalEventArgs e)
        {
            if (e.State == ObjectState.Create || e.State == ObjectState.Update)
            {
                voteThread.Subject = Formatter.FormatSingleLinePlainTextForStorage(voteThread.Subject);
                voteThread.Body = Formatter.FormatMultiLinePlainTextForStorage(voteThread.Body, true);
            }
        }

        #endregion

    }
}