﻿//------------------------------------------------------------------------------
// <copyright company="Tunynet">
// Copyright (c) Tunynet Inc. All rights reserved.
// </copyright> 
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using SpaceBuilder.Utils;
using SpaceBuilder.Common;
using SpaceBuilder.Web;
using System.Web.Routing;

namespace SpaceBuilder.Vote
{
    public static class SiteUrlsExtensions
    {
        /// <summary>
        /// 投票频道首页
        /// </summary>
        public static string ChannelVoteHome(this SiteUrls siteUrls)
        {
            return SPBUrlHelper.RouteUrl("Channel_Vote_Home");
        }
        #region Vote
        /// <summary>
        /// 显示投票
        /// </summary>
        public static string ShowVoteThread(this SiteUrls siteUrls, int threadID)
        {
            return ShowVoteThread(siteUrls, threadID, null);
        }
        /// <summary>
        /// 显示投票
        /// </summary>
        public static string ShowVoteThread(this SiteUrls siteUrls, int threadID, bool? isResult)
        {
            if (isResult.HasValue)
                return SPBUrlHelper.RouteUrl("Channel_Vote_ShowThread", new RouteValueDictionary { { "action", "ShowVoteThread" }, { "threadID", threadID }, { "isResult", isResult } });
            else
                return SPBUrlHelper.RouteUrl("Channel_Vote_ShowThread", new RouteValueDictionary { { "action", "ShowVoteThread" }, { "threadID", threadID } });
        }
        /// <summary>
        /// 显示群组投票
        /// </summary>
        public static string ShowClubVoteThread(this SiteUrls siteUrls, string clubDomainName, int threadID)
        {
            return SPBUrlHelper.RouteUrl("ClubDomain_Vote_ShowThread", new RouteValueDictionary { { "action", "ShowClubVoteThread" }, { "clubDomainName", clubDomainName }, { "threadID", threadID } });
        }
        /// <summary>
        /// 显示群组投票
        /// </summary>
        public static string ShowClubVoteThread(this SiteUrls siteUrls, string clubDomainName, int threadID, bool? isResult)
        {
            if (isResult.HasValue)
                return SPBUrlHelper.RouteUrl("ClubDomain_Vote_ShowThread", new RouteValueDictionary { { "action", "ShowClubVoteThread" }, { "clubDomainName", clubDomainName }, { "threadID", threadID }, { "isResult", isResult } });
            else
                return SPBUrlHelper.RouteUrl("ClubDomain_Vote_ShowThread", new RouteValueDictionary { { "action", "ShowClubVoteThread" }, { "clubDomainName", clubDomainName }, { "threadID", threadID } });
        }
        #endregion
    }
}
