﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using SpaceBuilder.Common.Controllers;
using System.Configuration;
using SpaceBuilder.Common;
using System.Xml;
using SpaceBuilder.Tasks;
using SpaceBuilder.Web;
using System.Xml.Linq;
using System.Reflection;

[assembly: log4net.Config.XmlConfigurator(ConfigFile = "web.config", Watch = true)]
namespace Web
{
    public class GlobalApplication : System.Web.HttpApplication
    {
        protected void Application_Start(Object source, EventArgs e)
        {
            #region log4net
            log4net.Config.XmlConfigurator.Configure();
            #endregion

            RegisterRoutes(RouteTable.Routes);

            ViewEngines.Engines.Clear();
            ViewEngines.Engines.Add(new ThemeViewEngine());

            #region 启动Task
            //iis7下HttpContext在Application_Start中无法使用Request
            XElement xmlRootElement = XElement.Load(HttpContext.Current.Server.MapPath("~/SpaceBuilder.config"));
            XElement tasksNode = xmlRootElement.Element("TaskSettings");
            ITaskController taskController = TaskControllerFactory.Instance.GetTaskController();
            taskController.Instantiate(tasksNode);
            taskController.CheckSavedTaskStatus();
            taskController.Start();
            #endregion

            //RouteDebugger.RewriteRoutesForTesting(RouteTable.Routes);            
        }

        protected void Application_End(Object source, EventArgs e)
        {
            ITaskController taskController = TaskControllerFactory.Instance.GetTaskController();
            taskController.SaveTaskStatus();
        }

        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            int iisVersion = Convert.ToInt32(ConfigurationManager.AppSettings["IISVersion"], System.Globalization.CultureInfo.InvariantCulture);
            if (iisVersion >= 7)
                RegisterRoutesForNewIIS(routes);
            else
                RegisterRoutesForOldIIS(routes);
        }

        /// <summary>
        /// IIS7以前的Route配置 
        /// </summary>
        public static void RegisterRoutesForOldIIS(RouteCollection routes)
        {
            routes.MapRoute(
                "Home",
                "Home.aspx",
                new { controller = "Channel", action = "Home" }
            );

            routes.MapRoute(
                "SimpleHome",
                "SimpleHome.aspx",
                new { controller = "Channel", action = "SimpleHome" }
            );

            routes.MapRoute(
                "Error",
                "Error.aspx",
                new { controller = "Channel", action = "Error" }
            );

            routes.MapRoute(
                "Error404",
                "Error404.aspx",
                new { controller = "Channel", action = "Error404" }
            );

            routes.MapRoute(
                "ShowExceptionMessage",
                "ShowExceptionMessage.aspx/{exceptionType}",
                new { controller = "Channel", action = "ShowExceptionMessage" }
            );

            routes.MapRoute(
               "ShowValidationMessage",
               "ValidationMessage.aspx/{exceptionType}",
               new { controller = "Channel", action = "ValidationMessage" }
           );

            #region 用户

            routes.MapRoute(
                "Channel_User_Common",
                "User/{action}.aspx",
                new { controller = "ChannelUser", action = "Login" }
            );

            #endregion

            #region 总站

            #region ChannelBlog
            routes.MapRoute(
                "Channel_Blog_ListBlogThreadsByTag",
                "Blog.aspx/Tag/{TagName}",
                new { controller = "ChannelBlog", action = "ListBlogThreadsByTag" }
            );
            routes.MapRoute(
                 "Channel_Blog_BlogRanks",
                 "Blog.aspx/Ranks/{sortBy}/",
                new { controller = "ChannelBlog", action = "ListBlogRanks" }
            );
            routes.MapRoute(
               "Channel_Blog_Search",
               "Blog.aspx/Search",
               new { controller = "ChannelBlog", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Blog_Home",
                "Blog.aspx",
                new { controller = "ChannelBlog", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Blog_Common",
                "Blog.aspx/{action}",
                new { controller = "ChannelBlog" }
            );
            #endregion

            #region ChannelPhoto
            routes.MapRoute(
                "Channel_Photo_ListPhotosByTag",
                "Photo.aspx/Tag/{TagName}",
                new { controller = "ChannelPhoto", action = "ListPhotosByTag" }
            );
            routes.MapRoute(
                 "Channel_Photo_PhotoRanks",
                 "Photo.aspx/PhotoRanks/{sortBy}/",
                new { controller = "ChannelPhoto", action = "PhotoRanks" }
            );
            routes.MapRoute(
                 "Channel_Photo_GalleryRanks",
                 "Photo.aspx/GalleryRanks/{sortBy}/",
                new { controller = "ChannelPhoto", action = "GalleryRanks" }
            );
            routes.MapRoute(
               "Channel_Photo_Search",
               "Photo.aspx/Search",
               new { controller = "ChannelPhoto", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Photo_Home",
                "Photo.aspx",
                new { controller = "ChannelPhoto", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Photo_Common",
                "Photo.aspx/{action}",
                new { controller = "ChannelPhoto" }
            );
            #endregion

            #region 公告
            routes.MapRoute(
                "Channel_Announcement_ShowAnnouncement",
                "Announcement.aspx/t-{threadID}",
                new { controller = "Channel", action = "ShowAnnouncement" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
                );
            #endregion

            #region ChannelFile
            routes.MapRoute(
                "Channel_File_ListFilesByTag",
                "File.aspx/Tag/{TagName}",
                new { controller = "ChannelFile", action = "ListFilesByTag" }
            );
            routes.MapRoute(
                 "Channel_File_FileRanks",
                 "File.aspx/Ranks/{sortBy}/",
                new { controller = "ChannelFile", action = "FileRanks" }
            );
            routes.MapRoute(
                "Channel_File_ShowFile",
                "File.aspx/t-{threadID}",
                new { controller = "ChannelFile", action = "ShowFile" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
               "Channel_File_Search",
               "File.aspx/Search",
               new { controller = "ChannelFile", action = "Search" }
            );
            routes.MapRoute(
                "Channel_File_Home",
                "File.aspx",
                new { controller = "ChannelFile", action = "Home" }
            );
            routes.MapRoute(
                "Channel_File_Common",
                "File.aspx/{action}",
                new { controller = "ChannelFile" }
            );
            #endregion

            #region ChannelClub
            routes.MapRoute(
                 "Channel_Club_Ranks",
                 "Club.aspx/Ranks/{sortBy}/",
                new { controller = "ChannelClub", action = "ClubList" }
            );
            routes.MapRoute(
               "Channel_Club_Search",
               "Club.aspx/Search",
               new { controller = "ChannelClub", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Club_Home",
                "Club.aspx",
                new { controller = "ChannelClub", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Club_Common",
                "Club.aspx/{action}",
                new { controller = "ChannelClub" }
            );
            #endregion

            #region ChannelEvent
            routes.MapRoute(
               "Channel_Event_Search",
               "Event.aspx/Search",
               new { controller = "ChannelEvent", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Event_Home",
                "Event.aspx",
                new { controller = "ChannelEvent", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Event_ShowEvent",
                "Event.aspx/T-{eventID}",
                new { controller = "ChannelEvent", action = "ShowEvent" },
                new { eventID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_Event_Common",
                "Event.aspx/{action}",
                new { controller = "ChannelEvent" }
            );
            #endregion

            #region ChannelNews
            routes.MapRoute(
                "Channel_News_ShowSection",
                "News.aspx/S-{sectionID}",
                new { controller = "ChannelNews", action = "ListNews" },
                new { sectionID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_News_ShowSectionIncludeChild",
                "News.aspx/SC-{sectionID}",
                new { controller = "ChannelNews", action = "ListNewsForChild" },
                new { sectionID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_News_ShowNews",
                "News.aspx/T-{newsID}",
                new { controller = "ChannelNews", action = "ShowNews" },
                new { newsID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
               "Channel_News_Search",
               "News.aspx/Search",
               new { controller = "ChannelNews", action = "Search" }
            );
            routes.MapRoute(
                "Channel_News_Home",
                "News.aspx",
                new { controller = "ChannelNews", action = "Home" }
            );
            routes.MapRoute(
                "Channel_News_Common",
                "News.aspx/{action}",
                new { controller = "ChannelNews" }
            );
            #endregion

            #region ChannelMember
            routes.MapRoute(
                 "Channel_Member_OnlineMembers",
                 "Member.aspx/Online/",
                new { controller = "Channel", action = "OnlineMembers" }
            );
            routes.MapRoute(
                 "Channel_Member_MemberRanks",
                 "Member.aspx/Ranks/",
                new { controller = "Channel", action = "MemberRanks" }
            );
            routes.MapRoute(
               "Channel_Member_Search",
               "Member.aspx/Search",
               new { controller = "ChannelUser", action = "UserSearch" }
            );
            routes.MapRoute(
               "Channel_Member_Home",
               "Member.aspx",
               new { controller = "Channel", action = "MemberHome" }
            );
            routes.MapRoute(
               "Channel_Member_Common",
               "Member.aspx/{action}",
               new { controller = "ChannelMember" }
            );
            #endregion

            #region ChannelGift

            routes.MapRoute(
                 "Channel_Gift_Home",
                 "Gift.aspx",
                new { controller = "ChannelConvertibleGift", action = "GiftHome" }
            );

            routes.MapRoute(
               "Channel_Gift_Detail",
               "Gift.aspx/g-{giftID}",
                new { controller = "ChannelConvertibleGift", action = "ShowGift" },
                new { giftID = @"(\d+)|(\{\d+\})" }
            );

            //routes.MapRoute(
            //   "Channel_Gift_List",
            //   "Gift.aspx/GiftList",
            //   new { controller = "ChannelConvertibleGift", action = "ShowGiftsList" }
            //);

            routes.MapRoute(
               "Channel_Gift_PriceBy",
               "Gift.aspx/ListGifts",
               new { controller = "ChannelConvertibleGift", action = "ListGifts" }
            );

            routes.MapRoute(
               "Channel_Gift_Common",
               "Gift.aspx/{action}",
               new { controller = "ChannelConvertibleGift" }
            );


            #endregion

            #region ChannelListing

            routes.MapRoute(
                "Channel_Listing_Home",
                "Listing.aspx",
                new { controller = "ChannelListing", action = "Home" }
            );

            routes.MapRoute(
                "Channel_Listing_ShowListing",
                "Listing.aspx/T-{threadID}",
                new { controller = "ChannelListing", action = "ShowListing" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
               "Channel_Listing_Search",
               "Listing.aspx/Search",
               new { controller = "ChannelListing", action = "Search" }
            );

            routes.MapRoute(
                "Channel_Listing_Common",
                "Listing.aspx/{action}",
                new { controller = "ChannelListing" }
            );

            #endregion

            #region 招聘

            routes.MapRoute(
                "Channel_Job_Home",
                "Job.aspx",
                new { controller = "ChannelJob", action = "Home" }
            );

            routes.MapRoute(
               "Channel_Job_Search",
               "Job.aspx/Search",
               new { controller = "ChannelJob", action = "JobSearch" }
            );

            routes.MapRoute(
                "Channel_Job_ShowCompany",
                "Job.aspx/C-{companyUserID}",
                new { controller = "ChannelJob", action = "ShowCompany" },
                new { companyUserID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "Channel_Job_ShowThread",
                "Job.aspx/T-{jobID}",
                new { controller = "ChannelJob", action = "ShowJob" },
                new { jobID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "Channel_Job_Common",
                "Job.aspx/{action}",
                new { controller = "ChannelJob" }
            );

            #endregion

            #region ChannelReward

            routes.MapRoute(
                "Channel_Reward_Home",
                "Reward.aspx",
                new { controller = "ChannelReward", action = "Home" }
            );

            routes.MapRoute(
            "Channel_Reward_ShowThread",
            "Reward.aspx/T-{threadID}",
            new { controller = "ChannelReward", action = "ShowReward" },
            new { threadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "Channel_Reward_Common",
                "Reward.aspx/{action}",
                new { controller = "ChannelReward" }
            );


            #endregion

            #region ChannelVote

            routes.MapRoute(
                "Channel_Vote_Home",
                "Vote.aspx",
                new { controller = "ChannelVote", action = "Home" }
            );

            routes.MapRoute(
                "Channel_Vote_ShowThread",
                "Vote.aspx/T-{threadID}",
                new { controller = "ChannelVote", action = "ShowVoteThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "Channel_Vote_Common",
                "Vote.aspx/{action}",
                new { controller = "ChannelVote" }
            );

            #endregion

            #region ChannelShare

            routes.MapRoute(
                "Channel_Share_Home",
                "Share.aspx",
                new { controller = "ChannelShare", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Share_ShowThread",
                "Share.aspx/T-{threadID}",
                new { controller = "ChannelShare", action = "ShowShareThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_Share_ListThreadsByTag",
                "Share.aspx/Tag/{tagName}",
                new { controller = "ChannelShare", action = "ListShareThreadsBySiteTag" }
            );
            routes.MapRoute(
                "Channel_Share_Common",
                "Share.aspx/{action}",
                new { controller = "ChannelShare" }
            );

            #endregion

            #region 论坛

            //论坛首页
            routes.MapRoute(
                "Channel_Forum_Home",
                "Forum.aspx",
                new { controller = "ChannelForum", action = "Home" }
            );

            //版块组
            routes.MapRoute(
                "Channel_Forum_ShowForumGroup",
                "Forum.aspx/g-{groupID}",
                new { controller = "ChannelForum", action = "ShowForumGroup" },
                new { groupID = @"(\d+)|(\{\d+\})" }
            );

            //版块
            routes.MapRoute(
                "Channel_Forum_ShowForumSection",
                "Forum.aspx/s-{sectionID}/{threadViewMode}",
                new { controller = "ChannelForum", action = "ShowForumSection", threadViewMode = "default" },
                new { sectionID = @"(\d+)|(\{\d+\})" }
            );

            //主题
            routes.MapRoute(
                "Channel_Forum_ShowForumThread",
                "Forum.aspx/t-{threadID}",
                new { controller = "ChannelForum", action = "ShowForumThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            //主题列表
            routes.MapRoute(
                "Channel_Forum_ListForumThreads",
                "Forum.aspx/ListThreads/{threadViewMode}",
                new { controller = "ChannelForum", action = "ListForumThreads", threadViewMode = "MostRecent" }
            );
            routes.MapRoute(
               "Channel_Forum_Search",
               "Forum.aspx/Search",
               new { controller = "ChannelForum", action = "Search" }
            );

            //论坛的其他页面
            routes.MapRoute(
                "Channel_Forum_Common",
                "Forum.aspx/{action}",
                new { controller = "ChannelForum" }
            );
            #endregion

            #endregion

            #region 群组
   

            #region ClubForum
            routes.MapRoute(
                "ClubDomain_Forum_Home",
                "c/{ClubDomainName}/Forum.aspx",
                new { controller = "ClubForum", action = "Home" }
            );
            routes.MapRoute(
             "ClubDomain_Forum_Common",
             "c/{ClubDomainName}/Forum.aspx/{action}",
             new { controller = "ClubForum" }
            );
            #endregion

            #region ClubVote
            routes.MapRoute(
                "ClubDomain_Vote_Home",
                "c/{ClubDomainName}/Vote.aspx",
                new { controller = "ClubVote", action = "ListClubVoteThreads" }
            );

            routes.MapRoute(
                "ClubDomain_Vote_ShowThread",
                "c/{ClubDomainName}/Vote.aspx/T-{threadID}",
                new { controller = "ClubVote", action = "ShowClubVoteThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
             "ClubDomain_Vote_Common",
             "c/{ClubDomainName}/Vote.aspx/{action}",
             new { controller = "ClubVote" }
            );
            #endregion

            #region ClubEvent
            routes.MapRoute(
                "ClubDomain_Event_Home",
                "c/{ClubDomainName}/Event.aspx",
                new { controller = "ClubEvent", action = "Home" }
            );
            routes.MapRoute(
              "ClubDomain_Event_Common",
              "c/{ClubDomainName}/Event.aspx/{action}",
              new { controller = "ClubEvent" }
            );
            #endregion

            #region ClubMember
            routes.MapRoute(
                "ClubDomain_Member_Home",
                "c/{ClubDomainName}/Member.aspx",
                new { controller = "ClubMember", action = "Home" }
            );
            routes.MapRoute(
              "ClubDomain_Member_Common",
              "c/{ClubDomainName}/Member.aspx/{action}",
              new { controller = "ClubMember" }
            );
            #endregion

            routes.MapRoute(
                 "ClubDomain_Manage_Home",
                 "c/{ClubDomainName}/Manage.aspx",
                 new { controller = "ClubManage", action = "Home" }
            );
            routes.MapRoute(
               "ClubDomain_Manage_Common",
               "c/{ClubDomainName}/Manage.aspx/{action}",
               new { controller = "ClubManage" }
            );
            routes.MapRoute(
            "ClubDomain_Home",
            "c/{ClubDomainName}.aspx",
            new { controller = "ClubDomain", action = "Home" }
            );



            routes.MapRoute(
                 "ClubDomain_Share_Home",
                 "c/{ClubDomainName}/Share.aspx",
                 new { controller = "ClubDomain", action = "Share" }
            );
            routes.MapRoute(
                 "ClubDomain_Common",
                 "c/{ClubDomainName}.aspx/{action}",
                 new { controller = "ClubDomain" }
            );

            #endregion

            #region 微博

            routes.MapRoute(
                "MicroBlogDomain_ShortUrl",
                "url.aspx/{shortUrl}",
                new { controller = "MicroBlog", action = "RedirectUrl" },
                new { shortUrl = @"([0-9a-zA-Z]{6})|(\{\d+\})" }
            );

            routes.MapRoute(
                "Manage_MicroBlog_Home",
                "Manage/ManageMicroBlog.aspx/{action}",
                new { controller = "ManageMicroBlog", action = "ManageMicroBlogThreads" }
            );

            routes.MapRoute(
                "MicroBlog_Screen",
                "t/screen.aspx/{screenID}",
                new { controller = "MicroBlog", action = "Screen" },
                new { screenID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "MicroBlog_ShowMicroBlogTopic",
                "t/ft.aspx/t-{topicID}",
                new { controller = "MicroBlog", action = "ShowMicroBlogTopic" },
                new { topicID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "MicroBlogDomain_ShowMicroBlog",
                "t/{UserDomainName}.aspx/t-{threadID}",
                new { controller = "MicroBlog", action = "ShowMicroBlogThread" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "MicroBlogDomain_UserMicroBlogs",
                "t/{UserDomainName}/Profile.aspx",
                new { controller = "MicroBlog", action = "ListMyMicroBlogThreads" }

            );

            routes.MapRoute(
                "MicroBlogDomain_Home",
                "t.aspx",
                new { controller = "MicroBlog", action = "MicroBlogHome" }

            );

            routes.MapRoute(
                "MicroBlogDomain_ReferUserMicroBlogs",
                "t/{UserDomainName}/Atme.aspx",
                new { controller = "MicroBlog", action = "ListReferMeMicroBlogs" }

            );

            routes.MapRoute(
                "MicroBlogDomain_MyHome",
                "t/{UserDomainName}.aspx",
                new { controller = "MicroBlog", action = "MyMicroBlogHome" }

            );

            routes.MapRoute(
                "MicroBlogDomain_User_Common",
                "t/{UserDomainName}/{action}.aspx",
                 new { controller = "MicroBlog" }
            );

            routes.MapRoute(
                "MicroBlogDomain_Common",
                "t/c/{action}.aspx",
                new { controller = "MicroBlog" }

            );

            #endregion

            #region 用户空间
            routes.MapRoute(
                "UserDomain_Home",
                "u/{UserDomainName}.aspx",
                new { controller = "UserDomain", action = "Home" }
            );
            routes.MapRoute(
                "UserDomain_MasterHome",
                "u/{UserDomainName}/Master.aspx",
                new { controller = "UserDomain", action = "Master" }
            );
            routes.MapRoute(
                "UserDomain_ShowProfile",
                "u/{UserDomainName}/ShowProfile.aspx",
                new { controller = "UserDomain", action = "ShowProfile" }
            );

            #region Blog
            routes.MapRoute(
                "UserDomain_Blog_ListBlogThreadsByYMD",
                "u/{UserDomainName}/Blog.aspx/archive/{year}/{month}/{day}",
                new { controller = "Blog", action = "ListBlogThreadsByYMD" },
                new { year = @"(\d+)|(\{\d+\})", month = @"(\d+)|(\{\d+\})", day = @"(\d+)|(\{\d+\})" }
                );
            routes.MapRoute(
                "UserDomain_Blog_ListBlogThreadsByYM",
                "u/{UserDomainName}/Blog.aspx/archive/{year}/{month}",
                new { controller = "Blog", action = "ListBlogThreadsByYMD" },
                new { year = @"(\d+)|(\{\d+\})", month = @"(\d+)|(\{\d+\})" }
                );

            routes.MapRoute(
                "UserDomain_Blog_ListBlogThreadsByY",
                "u/{UserDomainName}/Blog.aspx/archive/{year}",
                new { controller = "Blog", action = "ListBlogThreadsByYMD" },
                new { year = @"(\d+)|(\{\d+\})" }
                );

            routes.MapRoute(
                "UserDomain_Blog_ShowThread",
                "u/{UserDomainName}/Blog.aspx/t-{threadID}",
                new { controller = "Blog", action = "ShowBlogThread" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }

            );

            routes.MapRoute(
                "UserDomain_Blog_Newthread",
                "u/{UserDomainName}/Blog.aspx/{action}",
                new { controller = "Blog", action = "Home" }
            );
            #endregion

            #region Photo
            routes.MapRoute(
                "UserDomain_Photo_ShowPhoto",
                "u/{UserDomainName}/Photo.aspx/t-{threadID}",
                new { controller = "Photo", action = "ShowPhoto" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
               "UserDomain_Photo_Home",
               "u/{UserDomainName}/Photo.aspx/",
               new { controller = "Photo", action = "Home" }
           );

            routes.MapRoute(
                 "UserDomain_Photo_Common",
                 "u/{UserDomainName}/Photo.aspx/{action}",
                  new { controller = "Photo" }
             );

            #endregion

            #region File

            routes.MapRoute(
                "UserDomain_File_Common",
                "u/{UserDomainName}/File.aspx/{action}",
                 new { controller = "File", action = "Home" }
            );
            #endregion

            routes.MapRoute(
                "UserDomain_Listing_Home",
                "u/{UserDomainName}/Listing.aspx/",
                 new { controller = "Listing", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_Listing_Common",
                "u/{UserDomainName}/Listing.aspx/{action}",
                 new { controller = "Listing", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_News_Home",
                "u/{UserDomainName}/News.aspx/",
                 new { controller = "News", action = "ListNews" }
            );

            routes.MapRoute(
                "UserDomain_News_Common",
                "u/{UserDomainName}/News.aspx/{action}",
                 new { controller = "News" }
            );

            routes.MapRoute(
                "UserDomain_Friend_Common",
                "u/{UserDomainName}/Friend.aspx/{action}",
                 new { controller = "Friend", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_Forum_Common",
                "u/{UserDomainName}/Forum.aspx/{action}",
                 new { controller = "UserDomainForum", action = "ListMyForums" }
            );

            routes.MapRoute(
                "UserDomain_MessageCenter_Common",
                "u/{UserDomainName}/MessageCenter.aspx/{action}",
                new { controller = "MessageCenter", action = "ListVisitor" }
            );

            routes.MapRoute(
               "UserDomain_Event_Common",
               "u/{UserDomainName}/Event.aspx/{action}",
               new { controller = "UserDomainEvent", action = "ListMyEvents" }
           );
            routes.MapRoute(
               "UserDomain_Club_Common",
               "u/{UserDomainName}/Club.aspx/{action}",
               new { controller = "ClubUserDomain", action = "ListMyClubs" }
           );


            #region 投票
            routes.MapRoute(
               "UserDomain_Vote_Common",
               "u/{UserDomainName}/Vote.aspx/{action}",
               new { controller = "UserDomainVote", action = "ListMyVoteThreads" }
           );
            #endregion

            #region 分享
            routes.MapRoute(
                "UserDomain_Share_ShowUserThread",
                "u/{UserDomainName}/Share.aspx/UT-{userThreadID}",
                new { controller = "UserDomainShare", action = "ShowUserShareThread" },
                new { userThreadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "UserDomain_Share_ListUserThreadsByTag",
                "u/{UserDomainName}/Share.aspx/Tag/{tagName}",
                new { controller = "UserDomainShare", action = "ListUserShareThreadsByUserTag" }
            );
            routes.MapRoute(
               "UserDomain_Share_Common",
               "u/{UserDomainName}/Share.aspx/{action}",
               new { controller = "UserDomainShare", action = "ListMyUserShareThreads" }
           );
            #endregion

            #region 招聘

            routes.MapRoute(
                "UserDomain_Job_CompanyHome",
                "u/{UserDomainName}/Jobs.aspx",
                new { controller = "UserDomainJob", action = "CommpanyHome" }
            );

            routes.MapRoute(
                "UserDomain_Job_PersonHome",
                "u/{UserDomainName}/MyJobs.aspx",
                new { controller = "UserDomainJob", action = "PersonHome" }
            );

            routes.MapRoute(
                "UserDomain_Job_ShowThread",
                "u/{UserDomainName}/Job.aspx/T-{jobID}",
                new { controller = "UserDomainJob", action = "ShowJob" },
                new { jobID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "UserDomain_Job_Common",
                "u/{UserDomainName}/Job.aspx/{action}",
                new { controller = "UserDomainJob", action = "ManageJobApplys" }
            );

            #endregion

            #region 悬赏

            routes.MapRoute(
                "UserDomain_Reward_Common",
                "u/{UserDomainName}/Reward.aspx/{action}",
                 new { controller = "Reward", action = "Home" }
            );

            #endregion

            routes.MapRoute(
                "UserDomain_Settings_Common",
                "u/{UserDomainName}/Settings.aspx/{action}",
                new { controller = "UserDomainSettings", action = "EditProfile" }
            );

            routes.MapRoute(
                "UserDomain_Common",
                "u/{UserDomainName}/UserDomain.aspx/{action}",
                new { controller = "UserDomain", action = "SearchPostsInUserDomain" });

            #endregion

            #region 后台管理

            routes.MapRoute(
                 "Manage_Home",
                 "Manage/Default.aspx",
                 new { controller = "Manage", action = "Home" }
             );

            routes.MapRoute(
                "Manage_User_Home",
                "Manage/ManageUser.aspx/{action}",
                new { controller = "ManageUser", action = "ListUsers" }
            );

            #region  后台首页
            routes.MapRoute(
               "Manage_Blog_ManageableCount",
               "Manage/BlogManageableCounts.aspx",
               new { controller = "ManageBlog", action = "GetManageableCounts" }
            );
            routes.MapRoute(
                "Manage_Vote_ManageableCount",
                "Manage/VoteManageableCoutes.aspx",
                new { Controller = "ManageVote", action = "GetManageableCounts" }
                );
            routes.MapRoute(
             "Manage_Share_ManageableCount",
             "Manage/ShareManageableCoutes.aspx",
             new { Controller = "ManageShare", action = "GetManageableCounts" }
             );
            routes.MapRoute(
              "Manage_Reward_ManageableCount",
              "Manage/RewardManageableCoutes.aspx",
              new { Controller = "ManageReward", action = "GetManageableCounts" }
              );
            routes.MapRoute(
               "Manage_Photo_ManageableCount",
               "Manage/PhotoManageableCoutes.aspx",
               new { Controller = "ManagePhoto", action = "GetManageableCounts" }
             );
            routes.MapRoute(
              "Manage_News_ManageableCount",
              "Manage/NewsManageableCoutes.aspx",
              new { Controller = "ManageNews", action = "GetManageableCounts" }
             );

            routes.MapRoute(
             "Manage_Listing_ManageableCount",
             "Manage/ListingManageableCoutes.aspx",
             new { Controller = "ManageListing", action = "GetManageableCounts" }
            );

            routes.MapRoute(
            "Manage_Job_ManageableCount",
            "Manage/JobManageableCoutes.aspx",
            new { Controller = "ManageJob", action = "GetManageableCounts" }
            );

            routes.MapRoute(
            "Manage_File_ManageableCount",
            "Manage/FileManageableCoutes.aspx",
            new { Controller = "ManageFile", action = "GetManageableCounts" }
            );
            routes.MapRoute(
             "Manage_Forum_ManageableCount",
             "Manage/ForumManageableCoutes.aspx",
             new { Controller = "ManageForum", action = "GetManageableCounts" }
             );
            routes.MapRoute(
            "Manage_Event_ManageableCount",
            "Manage/EventManageableCoutes.aspx",
            new { Controller = "ManageEvent", action = "GetManageableCounts" }
            );
            routes.MapRoute(
             "Manage_Club_ManageableCount",
             "Manage/ClubManageableCoutes.aspx",
             new { Controller = "ManageClub", action = "GetManageableCounts" }
             );
            routes.MapRoute(
           "Manage_MicroBlog_ManageableCount",
           "Manage/MicroBlogManageableCoutes.aspx",
           new { Controller = "ManageMicroBlog", action = "GetManageableCounts" }
           );
            #endregion

            #region
            routes.MapRoute(
                "Manage_Blog_Home",
                "Manage/ManageBlog.aspx/{action}",
                new { controller = "ManageBlog", action = "ListBlogArticle" }
            );

            routes.MapRoute(
                "Manage_Photo_Home",
                "Manage/ManagePhoto.aspx/{action}",
                new { controller = "ManagePhoto", action = "ManageThreads" }
            );

            routes.MapRoute(
                "Manage_File_Home",
                "Manage/ManageFile.aspx/{action}",
                new { controller = "ManageFile", action = "ListManageFiles" }
            );


            routes.MapRoute(
                "Manage_News_Home",
                "Manage/ManageNews.aspx/{action}",
                new { controller = "ManageNews", action = "ManageNews" }
            );

            routes.MapRoute(
                "Manage_Forum_Home",
                "Manage/ManageForum.aspx/{action}",
                new { controller = "ManageForum", action = "ManageForumThreads" }
            );

            routes.MapRoute(
                "Manage_Event_Home",
                "Manage/ManageEvent.aspx/{action}",
                new { controller = "ManageEvent", action = "ManageEvents" }
            );

            routes.MapRoute(
                "Manage_Club_Home",
                "Manage/ManageClub.aspx/{action}",
                new { controller = "ManageClub", action = "ListClubs" }
            );

            #region 投票
            routes.MapRoute(
                "Manage_Vote_Home",
                "Manage/ManageVote.aspx/{action}",
                new { controller = "ManageVote", action = "ManageVoteThreads" }
            );
            #endregion

            #region 分享
            routes.MapRoute(
                "Manage_Share_Home",
                "Manage/ManageShare.aspx/{action}",
                new { controller = "ManageShare", action = "ManageShareThreads" }
            );
            #endregion

            routes.MapRoute(
                "Manage_Job_Home",
                "Manage/ManageJob.aspx/{action}",
                new { controller = "ManageJob", action = "ManageJobs" }
            );

            routes.MapRoute(
                "Manage_Listing_Home",
                "Manage/ManageListing.aspx/{action}",
                new { controller = "ManageListing", action = "ManageListings" }
            );

            #region ManageReward

            routes.MapRoute(
              "Manage_Reward_Home",
              "Manage/ManageReward.aspx/{action}",
              new { controller = "ManageReward", action = "ManageRewardThreads" }
          );

            #endregion

            routes.MapRoute(
                 "Manage_Common",
                 "Manage/Manage.aspx/{action}",
                 new { controller = "Manage" }
             );

            routes.MapRoute(
                "Manage_ManageSettingsCommon",
                "Manage/ManageSettings.aspx/{action}",
                new { controller = "ManageSettings" }
            );

            routes.MapRoute(
                "Manage_AuxiliariesCommon",
                "Manage/Auxiliaries.aspx/{action}",
                new { controller = "Auxiliaries" }
            );

            #endregion

            routes.MapRoute(
                "Common",
                "{controller}.aspx/{action}",
                new { controller = "Channel", action = "Home" }
            );
            #endregion
        }

        /// <summary>
        /// IIS7的Route配置 
        /// </summary>
        private static void RegisterRoutesForNewIIS(RouteCollection routes)
        {
            routes.MapRoute(
               "Home",
               "",
               new { controller = "Channel", action = "Home" }
            );

            routes.MapRoute(
                "SimpleHome",
                "SimpleHome.aspx",
                new { controller = "Channel", action = "SimpleHome" }
            );

            routes.MapRoute(
                "Error",
                "Error.aspx",
                new { controller = "Channel", action = "Error" }
            );

            routes.MapRoute(
                "Error404",
                "Error404.aspx",
                new { controller = "Channel", action = "Error404" }
            );

            routes.MapRoute(
                "ShowExceptionMessage",
                "ShowExceptionMessage/{exceptionType}",
                new { controller = "Channel", action = "ShowExceptionMessage" }
            );

            routes.MapRoute(
             "ShowValidationMessage",
             "ValidationMessage/{exceptionType}",
             new { controller = "Channel", action = "ValidationMessage" }
         );


            #region 用户

            routes.MapRoute(
                "Channel_User_Common",
                "User/{action}.aspx",
                new { controller = "ChannelUser", action = "Login" }
            );

            #endregion

            #region 总站

            #region ChannelBlog
            routes.MapRoute(
                "Channel_Blog_ListBlogThreadsByTag",
                "Blog/Tag/{TagName}",
                new { controller = "ChannelBlog", action = "ListBlogThreadsByTag" }
            );
            routes.MapRoute(
                 "Channel_Blog_PostRanks",
                 "Blog/PostRanks/{sortBy}/",
                new { controller = "ChannelBlog", action = "ListPostRanks" }
            );
            routes.MapRoute(
                 "Channel_Blog_BlogRanks",
                 "Blog/Ranks/{sortBy}/",
                new { controller = "ChannelBlog", action = "ListBlogRanks" }
            );
            routes.MapRoute(
               "Channel_Blog_Search",
               "Blog/Search",
               new { controller = "ChannelBlog", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Blog_Home",
                "Blog",
                new { controller = "ChannelBlog", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Blog_Common",
                "Blog/{action}",
                new { controller = "ChannelBlog" }
            );
            #endregion

            #region ChannelPhoto
            routes.MapRoute(
                "Channel_Photo_ListPhotosByTag",
                "Photo/Tag/{TagName}",
                new { controller = "ChannelPhoto", action = "ListPhotosByTag" }
            );
            routes.MapRoute(
                 "Channel_Photo_PhotoRanks",
                 "Photo/PhotoRanks/{sortBy}/",
                new { controller = "ChannelPhoto", action = "PhotoRanks" }
            );
            routes.MapRoute(
                 "Channel_Photo_GalleryRanks",
                 "Photo/GalleryRanks/{sortBy}/",
                new { controller = "ChannelPhoto", action = "GalleryRanks" }
            );
            routes.MapRoute(
               "Channel_Photo_Search",
               "Photo/Search",
               new { controller = "ChannelPhoto", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Photo_Home",
                "Photo",
                new { controller = "ChannelPhoto", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Photo_Common",
                "Photo/{action}",
                new { controller = "ChannelPhoto" }
            );
            #endregion

            #region ChannelAnnouncement 公告
            routes.MapRoute(
                "Channel_Announcement_ShowAnnouncement",
                "Announcement/t-{threadID}",
                new { controller = "Channel", action = "ShowAnnouncement" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
                );
            #endregion
            #region ChannelFile
            routes.MapRoute(
                "Channel_File_ListFilesByTag",
                "File/Tag/{TagName}",
                new { controller = "ChannelFile", action = "ListFilesByTag" }
            );
            routes.MapRoute(
                 "Channel_File_FileRanks",
                 "File/Ranks/{sortBy}/",
                new { controller = "ChannelFile", action = "FileRanks" }
            );
            routes.MapRoute(
                "Channel_File_ShowFile",
                "File/t-{threadID}",
                new { controller = "ChannelFile", action = "ShowFile" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
               "Channel_File_Search",
               "File/Search",
               new { controller = "ChannelFile", action = "Search" }
            );
            routes.MapRoute(
                "Channel_File_Home",
                "File",
                new { controller = "ChannelFile", action = "Home" }
            );
            routes.MapRoute(
                "Channel_File_Common",
                "File/{action}",
                new { controller = "ChannelFile" }
            );
            #endregion

            #region ChannelClub
            routes.MapRoute(
                 "Channel_Club_Ranks",
                 "Club/Ranks/{sortBy}/",
                new { controller = "ChannelClub", action = "ClubList" }
            );
            routes.MapRoute(
               "Channel_Club_Search",
               "Club/Search",
               new { controller = "ChannelClub", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Club_Home",
                "Club",
                new { controller = "ChannelClub", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Club_Common",
                "Club/{action}",
                new { controller = "ChannelClub" }
            );
            #endregion

            #region ChannelEvent
            routes.MapRoute(
               "Channel_Event_Search",
               "Event/Search",
               new { controller = "ChannelEvent", action = "Search" }
            );
            routes.MapRoute(
                "Channel_Event_Home",
                "Event",
                new { controller = "ChannelEvent", action = "Home" }
            );
            routes.MapRoute(
              "Channel_Event_ShowEvent",
              "Event/T-{eventID}",
              new { controller = "ChannelEvent", action = "ShowEvent" },
              new { eventID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_Event_Common",
                "Event/{action}",
                new { controller = "ChannelEvent" }
            );
            #endregion

            #region ChannelNews
            routes.MapRoute(
                "Channel_News_ShowSection",
                "News/S-{sectionID}",
                new { controller = "ChannelNews", action = "ListNews" },
                new { sectionID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_News_ShowSectionIncludeChild",
                "News/SC-{sectionID}",
                new { controller = "ChannelNews", action = "ListNewsForChild" },
                new { sectionID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_News_ShowNews",
                "News/T-{newsID}",
                new { controller = "ChannelNews", action = "ShowNews" },
                new { newsID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
               "Channel_News_Search",
               "News/Search",
               new { controller = "ChannelNews", action = "Search" }
            );
            routes.MapRoute(
                "Channel_News_Home",
                "News",
                new { controller = "ChannelNews", action = "Home" }
            );
            routes.MapRoute(
                "Channel_News_Common",
                "News/{action}",
                new { controller = "ChannelNews" }
            );
            #endregion

            #region ChannelMember
            routes.MapRoute(
                 "Channel_Member_OnlineMembers",
                 "Member/Online/",
                new { controller = "Channel", action = "OnlineMembers" }
            );
            routes.MapRoute(
                 "Channel_Member_MemberRanks",
                 "Member/Ranks/",
                new { controller = "Channel", action = "MemberRanks" }
            );
            routes.MapRoute(
               "Channel_Member_Search",
               "Member/Search",
               new { controller = "ChannelUser", action = "UserSearch" }
            );
            routes.MapRoute(
               "Channel_Member_Home",
               "Member",
               new { controller = "Channel", action = "MemberHome" }
            );
            routes.MapRoute(
               "Channel_Member_Common",
               "Member/{action}",
               new { controller = "ChannelMember" }
            );
            #endregion

            #region ChannelGift
            routes.MapRoute(
               "Channel_Gift_Home",
               "Gift",
               new { controller = "ChannelConvertibleGift", action = "GiftHome" }
            );

            routes.MapRoute(
               "Channel_Gift_Detail",
              "Gift/g-{giftID}",
                new { controller = "ChannelConvertibleGift", action = "ShowGift" },
                new { giftID = @"(\d+)|(\{\d+\})" }
            );

            //routes.MapRoute(
            //   "Channel_Gift_List",
            //   "Gift/GiftList",
            //   new { controller = "ChannelConvertibleGift", action = "ShowGiftsList" }
            //);

            routes.MapRoute(
               "Channel_Gift_PriceBy",
               "Gift/ListGifts",
               new { controller = "ChannelConvertibleGift", action = "ListGifts" }
            );

            routes.MapRoute(
               "Channel_Gift_Common",
               "Gift/{action}",
               new { controller = "ChannelConvertibleGift" }
            );

            #endregion

            #region ChannelVote

            routes.MapRoute(
                "Channel_Vote_Home",
                "Vote",
                new { controller = "ChannelVote", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Vote_ShowThread",
                "Vote/T-{threadID}",
                new { controller = "ChannelVote", action = "ShowVoteThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_Vote_Common",
                "Vote/{action}",
                new { controller = "ChannelVote" }
            );

            #endregion

            #region ChannelShare

            routes.MapRoute(
                "Channel_Share_Home",
                "Share",
                new { controller = "ChannelShare", action = "Home" }
            );
            routes.MapRoute(
                "Channel_Share_ShowThread",
                "Share/T-{threadID}",
                new { controller = "ChannelShare", action = "ShowShareThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "Channel_Share_ListThreadsByTag",
                "Share/Tag/{tagName}",
                new { controller = "ChannelShare", action = "ListShareThreadsBySiteTag" }
            );
            routes.MapRoute(
                "Channel_Share_Common",
                "Share/{action}",
                new { controller = "ChannelShare" }
            );

            #endregion

            #region ChannelListing

            routes.MapRoute(
                "Channel_Listing_Home",
                "Listing",
                new { controller = "ChannelListing", action = "Home" }
            );

            routes.MapRoute(
                "Channel_Listing_ShowListing",
                "Listing/T-{threadID}",
                new { controller = "ChannelListing", action = "ShowListing" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
               "Channel_Listing_Search",
               "Listing/Search",
               new { controller = "ChannelListing", action = "Search" }
            );

            routes.MapRoute(
                "Channel_Listing_Common",
                "Listing/{action}",
                new { controller = "ChannelListing" }
            );

            #endregion

            #region ChannelJob

            routes.MapRoute(
                "Channel_Job_Home",
                "Job",
                new { controller = "ChannelJob", action = "Home" }
            );
            routes.MapRoute(
               "Channel_Job_Search",
               "Job/Search",
               new { controller = "ChannelJob", action = "JobSearch" }
            );

            routes.MapRoute(
                "Channel_Job_ShowCompany",
                "Job/C-{companyUserID}",
                new { controller = "ChannelJob", action = "ShowCompany" },
                new { companyUserID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                 "Channel_Job_ShowThread",
                 "Job/T-{jobID}",
                 new { controller = "ChannelJob", action = "ShowJob" },
                 new { jobID = @"(\d+)|(\{\d+\})" }
             );

            routes.MapRoute(
                "Channel_Job_Common",
                "Job/{action}",
                new { controller = "ChannelJob" }
            );

            #endregion

            #region ChannelReward

            routes.MapRoute(
                "Channel_Reward_Home",
                "Reward/",
                new { controller = "ChannelReward", action = "Home" }
            );

            routes.MapRoute(
             "Channel_Reward_ShowThread",
             "Reward/T-{threadID}",
             new { controller = "ChannelReward", action = "ShowReward" },
             new { threadID = @"(\d+)|(\{\d+\})" }
             );

            routes.MapRoute(
                "Channel_Reward_Common",
                "Reward.aspx/{action}",
                new { controller = "ChannelReward" }
            );

            #endregion

            #region 论坛

            //论坛首页
            routes.MapRoute(
                "Channel_Forum_Home",
                "Forum",
                new { controller = "ChannelForum", action = "Home" }
            );

            //版块组
            routes.MapRoute(
                "Channel_Forum_ShowForumGroup",
                "Forum/g-{groupID}",
                new { controller = "ChannelForum", action = "ShowForumGroup" },
                new { groupID = @"(\d+)|(\{\d+\})" }
            );

            //版块
            routes.MapRoute(
                "Channel_Forum_ShowForumSection",
                "Forum/s-{sectionID}/{threadViewMode}",
                new { controller = "ChannelForum", action = "ShowForumSection", threadViewMode = "default" },
                new { sectionID = @"(\d+)|(\{\d+\})" }
            );

            //主题
            routes.MapRoute(
                "Channel_Forum_ShowForumThread",
                "Forum/t-{threadID}",
                new { controller = "ChannelForum", action = "ShowForumThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            //主题列表
            routes.MapRoute(
                "Channel_Forum_ListForumThreads",
                "Forum/ListThreads/{threadViewMode}",
                new { controller = "ChannelForum", action = "ListForumThreads", threadViewMode = "MostRecent" }
            );

            routes.MapRoute(
               "Channel_Forum_Search",
               "Forum/Search",
               new { controller = "ChannelForum", action = "Search" }
            );

            //论坛的其他页面
            routes.MapRoute(
                "Channel_Forum_Common",
                "Forum/{action}",
                new { controller = "ChannelForum" }
            );
            #endregion

            #endregion

            #region 群组
            routes.MapRoute(
                "ClubDomain_Forum_Home",
                "c/{ClubDomainName}/Forum",
                new { controller = "ClubForum", action = "Home" }
            );
            routes.MapRoute(
             "ClubDomain_Forum_Common",
             "c/{ClubDomainName}/Forum/{action}",
             new { controller = "ClubForum" }
            );
            routes.MapRoute(
                "ClubDomain_Event_Home",
                "c/{ClubDomainName}/Event",
                new { controller = "ClubEvent", action = "Home" }
           );
            routes.MapRoute(
              "ClubDomain_Event_Common",
              "c/{ClubDomainName}/Event/{action}",
              new { controller = "ClubEvent" }
           );

            #region ClubVote
            routes.MapRoute(
                "ClubDomain_Vote_Home",
                "c/{ClubDomainName}/Vote",
                new { controller = "ClubVote", action = "ListClubVoteThreads" }
            );

            routes.MapRoute(
                "ClubDomain_Vote_ShowThread",
                "c/{ClubDomainName}/Vote/T-{threadID}",
                new { controller = "ClubVote", action = "ShowClubVoteThread" },
                new { threadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
             "ClubDomain_Vote_Common",
             "c/{ClubDomainName}/Vote/{action}",
             new { controller = "ClubVote" }
            );
            #endregion

            routes.MapRoute(
                "ClubDomain_Member_Home",
                "c/{ClubDomainName}/Member",
                new { controller = "ClubMember", action = "Home" }
           );
            routes.MapRoute(
              "ClubDomain_Member_Common",
              "c/{ClubDomainName}/Member/{action}",
              new { controller = "ClubMember" }
           );
            routes.MapRoute(
                 "ClubDomain_Manage_Home",
                 "c/{ClubDomainName}/Manage",
                 new { controller = "ClubManage", action = "Home" }
           );
            routes.MapRoute(
               "ClubDomain_Manage_Common",
               "c/{ClubDomainName}/Manage/{action}",
               new { controller = "ClubManage" }
            );
            routes.MapRoute(
            "ClubDomain_Home",
            "c/{ClubDomainName}",
            new { controller = "ClubDomain", action = "Home" }
            );



            routes.MapRoute(
                 "ClubDomain_Share_Home",
                 "c/{ClubDomainName}/Share",
                 new { controller = "ClubDomain", action = "Share" }
            );
            routes.MapRoute(
                 "ClubDomain_Common",
                 "c/{ClubDomainName}/{action}",
                 new { controller = "ClubDomain" }
            );

            #endregion

            #region 微博

            routes.MapRoute(
                "MicroBlogDomain_ShortUrl",
                "url/{shortUrl}",
                new { controller = "MicroBlog", action = "RedirectUrl" },
                new { shortUrl = @"[0-9a-zA-Z]{6}|(\{\d+\})" }
            );

            routes.MapRoute(
                "Manage_MicroBlog_Home",
                "Manage/ManageMicroBlog/{action}",
                new { controller = "ManageMicroBlog", action = "ManageMicroBlogThreads" }
            );

            routes.MapRoute(
                "MicroBlog_Screen",
                "t/screen/{screenID}",
                new { controller = "MicroBlog", action = "Screen" },
                new { screenID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "MicroBlog_ShowMicroBlogTopic",
                "t/ft/t-{topicID}",
                new { controller = "MicroBlog", action = "ShowMicroBlogTopic" },
                new { topicID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "MicroBlogDomain_ShowMicroBlog",
                "t/{UserDomainName}/t-{threadID}",
                new { controller = "MicroBlog", action = "ShowMicroBlogThread" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "MicroBlogDomain_UserMicroBlogs",
                "t/{UserDomainName}/Profile",
                new { controller = "MicroBlog", action = "ListMyMicroBlogThreads" }

            );

            routes.MapRoute(
                "MicroBlogDomain_Home",
                "t",
                new { controller = "MicroBlog", action = "MicroBlogHome" }

            );

            routes.MapRoute(
                "MicroBlogDomain_ReferUserMicroBlogs",
                "t/{UserDomainName}/Atme",
                new { controller = "MicroBlog", action = "ListReferMeMicroBlogs" }

            );

            routes.MapRoute(
                "MicroBlogDomain_MyHome",
                "t/{UserDomainName}",
                new { controller = "MicroBlog", action = "MyMicroBlogHome" }

            );

            routes.MapRoute(
                "MicroBlogDomain_User_Common",
                "t/{UserDomainName}/{action}",
                 new { controller = "MicroBlog" }
            );

            routes.MapRoute(
                "MicroBlogDomain_Common",
                "t/c/{action}",
                new { controller = "MicroBlog" }

            );

            #endregion

            #region 用户空间

            routes.MapRoute(
                "UserDomain_Home",
                "u/{UserDomainName}",
                new { controller = "UserDomain", action = "Home" }
            );
            routes.MapRoute(
                "UserDomain_MasterHome",
                "u/{UserDomainName}/Master",
                new { controller = "UserDomain", action = "Master" }
            );
            routes.MapRoute(
                "UserDomain_ShowProfile",
                "u/{UserDomainName}/ShowProfile",
                new { controller = "UserDomain", action = "ShowProfile" }
            );

            routes.MapRoute(
                "UserDomain_Blog_ListBlogThreadsByYMD",
                "u/{UserDomainName}/Blog/archive/{year}/{month}/{day}",
                new { controller = "Blog", action = "ListBlogThreadsByYMD" },
                new { year = @"(\d+)|(\{\d+\})", month = @"(\d+)|(\{\d+\})", day = @"(\d+)|(\{\d+\})" }
                );
            routes.MapRoute(
                "UserDomain_Blog_ListBlogThreadsByYM",
                "u/{UserDomainName}/Blog/archive/{year}/{month}",
                new { controller = "Blog", action = "ListBlogThreadsByYMD" },
                new { year = @"(\d+)|(\{\d+\})", month = @"(\d+)|(\{\d+\})" }
                );

            routes.MapRoute(
                "UserDomain_Blog_ListBlogThreadsByY",
                "u/{UserDomainName}/Blog/archive/{year}",
                new { controller = "Blog", action = "ListBlogThreadsByYMD" },
                new { year = @"(\d+)|(\{\d+\})" }
                );

            routes.MapRoute(
                "UserDomain_Blog_ShowThread",
                "u/{UserDomainName}/Blog/t-{threadID}",
                new { controller = "Blog", action = "ShowBlogThread" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }

            );

            routes.MapRoute(
                "UserDomain_Blog_Newthread",
                "u/{UserDomainName}/Blog/{action}",
                new { controller = "Blog", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_Photo_ShowPhoto",
                "u/{UserDomainName}/Photo/t-{threadID}",
                new { controller = "Photo", action = "ShowPhoto" },
                new { ThreadID = @"(\d+)|(\{\d+\})" }

            );

            routes.MapRoute(
              "UserDomain_Photo_Home",
              "u/{UserDomainName}/Photo",
              new { controller = "Photo", action = "Home" }
          );

            routes.MapRoute(
                "UserDomain_Photo_Common",
                "u/{UserDomainName}/Photo/{action}",
                 new { controller = "Photo", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_File_Common",
                "u/{UserDomainName}/File/{action}",
                 new { controller = "File", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_Listing_Home",
                "u/{UserDomainName}/Listing/",
                 new { controller = "Listing", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_Listing_Common",
                "u/{UserDomainName}/Listing/{action}",
                 new { controller = "Listing", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_News_Home",
                "u/{UserDomainName}/News/",
                 new { controller = "News", action = "ListNews" }
            );

            routes.MapRoute(
                "UserDomain_News_Common",
                "u/{UserDomainName}/News/{action}",
                 new { controller = "News", action = "ListNews" }
            );

            routes.MapRoute(
                "UserDomain_Friend_Common",
                "u/{UserDomainName}/Friend/{action}",
                 new { controller = "Friend", action = "Home" }
            );

            routes.MapRoute(
                "UserDomain_Forum_Common",
                "u/{UserDomainName}/Forum/{action}",
                 new { controller = "UserDomainForum", action = "ListMyForums" }
            );

            routes.MapRoute(
                "UserDomain_MessageCenter_Common",
                "u/{UserDomainName}/MessageCenter.aspx/{action}",
                new { controller = "MessageCenter", action = "ListVisitor" }
            );

            routes.MapRoute(
               "UserDomain_Event_Common",
               "u/{UserDomainName}/Event/{action}",
               new { controller = "UserDomainEvent", action = "ListMyEvents" }
           );
            routes.MapRoute(
                "UserDomain_Club_Common",
                "u/{UserDomainName}/Club/{action}",
                new { controller = "ClubUserDomain", action = "ListMyClubs" }
            );

            #region 招聘

            routes.MapRoute(
                "UserDomain_Job_CompanyHome",
                "u/{UserDomainName}/Jobs",
                new { controller = "UserDomainJob", action = "CommpanyHome" }
            );

            routes.MapRoute(
                "UserDomain_Job_PersonHome",
                "u/{UserDomainName}/MyJobs",
                new { controller = "UserDomainJob", action = "PersonHome" }
            );

            routes.MapRoute(
                "UserDomain_Job_ShowThread",
                "u/{UserDomainName}/Job/T-{jobID}",
                new { controller = "UserDomainJob", action = "ShowJob" },
                new { jobID = @"(\d+)|(\{\d+\})" }
            );

            routes.MapRoute(
                "UserDomain_Job_Common",
                "u/{UserDomainName}/Job/{action}",
                new { controller = "UserDomainJob" }
            );

            #endregion


            #region 投票
            routes.MapRoute(
               "UserDomain_Vote_Common",
               "u/{UserDomainName}/Vote/{action}",
               new { controller = "UserDomainVote", action = "ListMyVoteThreads" }
           );
            #endregion

            #region 分享
            routes.MapRoute(
                "UserDomain_Share_ShowUserThread",
                "u/{UserDomainName}/Share/{userThreadID}",
                new { controller = "UserDomainShare", action = "ShowUserShareThread" },
                new { userThreadID = @"(\d+)|(\{\d+\})" }
            );
            routes.MapRoute(
                "UserDomain_Share_ListUserThreadsByTag",
                "u/{UserDomainName}/Share/Tag/{tagName}",
                new { controller = "UserDomainShare", action = "ListUserShareThreadsByUserTag" }
            );
            routes.MapRoute(
               "UserDomain_Share_Common",
               "u/{UserDomainName}/Share/{action}",
               new { controller = "UserDomainShare", action = "ListMyUserShareThreads" }
           );
            #endregion

            #region Reward

            routes.MapRoute(
                "UserDomain_Reward_Common",
                "u/{UserDomainName}/Reward/{action}",
                 new { controller = "Reward", action = "Home" }
            );

            #endregion

            routes.MapRoute(
                "UserDomain_Settings_Common",
                "u/{UserDomainName}/Settings.aspx/{action}",
                new { controller = "UserDomainSettings", action = "EditProfile" }
            );

            routes.MapRoute(
                "UserDomain_Common",
                "u/{UserDomainName}/UserDomain.aspx/{action}",
                new { controller = "UserDomain" });

            #endregion

            #region 后台管理

            routes.MapRoute(
                "Manage_Home",
                "Manage/Default.aspx",
                new { controller = "Manage", action = "Home" }
            );

            routes.MapRoute(
               "Manage_User_Home",
               "Manage/ManageUser.aspx/{action}",
               new { controller = "ManageUser", action = "ListUsers" }
           );
            #region  后台首页
            routes.MapRoute(
               "Manage_Blog_ManageableCount",
               "Manage/BlogManageableCounts.aspx",
               new { controller = "ManageBlog", action = "GetManageableCounts" }
            );
            routes.MapRoute(
                "Manage_Vote_ManageableCount",
                "Manage/VoteManageableCoutes.aspx",
                new { Controller = "ManageVote", action = "GetManageableCounts" }
                );
            routes.MapRoute(
             "Manage_Share_ManageableCount",
             "Manage/ShareManageableCoutes.aspx",
             new { Controller = "ManageShare", action = "GetManageableCounts" }
             );
            routes.MapRoute(
               "Manage_Photo_ManageableCount",
               "Manage/PhotoManageableCoutes.aspx",
               new { Controller = "ManagePhoto", action = "GetManageableCounts" }
             );
            routes.MapRoute(
              "Manage_News_ManageableCount",
              "Manage/NewsManageableCoutes.aspx",
              new { Controller = "ManageNews", action = "GetManageableCounts" }
             );

            routes.MapRoute(
             "Manage_Listing_ManageableCount",
             "Manage/ListingManageableCoutes.aspx",
             new { Controller = "ManageListing", action = "GetManageableCounts" }
            );

            routes.MapRoute(
            "Manage_Job_ManageableCount",
            "Manage/JobManageableCoutes.aspx",
            new { Controller = "ManageJob", action = "GetManageableCounts" }
            );
            routes.MapRoute(
           "Manage_Reward_ManageableCount",
           "Manage/RewardManageableCoutes.aspx",
           new { Controller = "ManageReward", action = "GetManageableCounts" }
           );
            routes.MapRoute(
            "Manage_File_ManageableCount",
            "Manage/FileManageableCoutes.aspx",
            new { Controller = "ManageFile", action = "GetManageableCounts" }
            );
            routes.MapRoute(
             "Manage_Forum_ManageableCount",
             "Manage/ForumManageableCoutes.aspx",
             new { Controller = "ManageForum", action = "GetManageableCounts" }
             );
            routes.MapRoute(
            "Manage_Event_ManageableCount",
            "Manage/EventManageableCoutes.aspx",
            new { Controller = "ManageEvent", action = "GetManageableCounts" }
            );
            routes.MapRoute(
             "Manage_Club_ManageableCount",
             "Manage/ClubManageableCoutes.aspx",
             new { Controller = "ManageClub", action = "GetManageableCounts" }
             );
            routes.MapRoute(
           "Manage_MicroBlog_ManageableCount",
           "Manage/MicroBlogManageableCoutes.aspx",
           new { Controller = "ManageMicroBlog", action = "GetManageableCounts" }
           );
            #endregion
            routes.MapRoute(
               "Manage_Blog_Home",
               "Manage/ManageBlog.aspx/{action}",
               new { controller = "ManageBlog", action = "ListBlogArticle" }
           );
            routes.MapRoute(
                "Manage_Photo_Home",
                "Manage/ManagePhoto.aspx/{action}",
                new { controller = "ManagePhoto", action = "ManageThreads" }
            );

            routes.MapRoute(
                "Manage_File_Home",
                "Manage/ManageFile.aspx/{action}",
                new { controller = "ManageFile", action = "ListManageFiles" }
            );

            routes.MapRoute(
                "Manage_News_Home",
                "Manage/ManageNews.aspx/{action}",
                new { controller = "ManageNews", action = "ManageNews" }
            );

            routes.MapRoute(
                "Manage_Forum_Home",
                "Manage/ManageForum.aspx/{action}",
                new { controller = "ManageForum", action = "ManageForumThreads" }
            );

            routes.MapRoute(
                "Manage_Event_Home",
                "Manage/ManageEvent.aspx/{action}",
                new { controller = "ManageEvent", action = "ManageEvents" }
            );

            routes.MapRoute(
                "Manage_Club_Home",
                "Manage/ManageClub.aspx/{action}",
                new { controller = "ManageClub", action = "ListClubs" }
            );

            routes.MapRoute(
                "Manage_Job_Home",
                "Manage/ManageJob.aspx/{action}",
                new { controller = "ManageJob", action = "ManageJobs" }
            );

            routes.MapRoute(
                "Manage_Listing_Home",
                "Manage/ManageListing.aspx/{action}",
                new { controller = "ManageListing", action = "ManageListings" }
            );

            #region 投票
            routes.MapRoute(
                "Manage_Vote_Home",
                "Manage/ManageVote.aspx/{action}",
                new { controller = "ManageVote", action = "ManageVoteThreads" }
            );
            #endregion

            #region 分享
            routes.MapRoute(
                "Manage_Share_Home",
                "Manage/ManageShare/{action}",
                new { controller = "ManageShare", action = "ManageShareThreads" }
            );
            #endregion

            #region ManageReward

            routes.MapRoute(
              "Manage_Reward_Home",
              "Manage/ManageReward.aspx/{action}",
              new { controller = "ManageReward", action = "ManageRewardThreads" }
          );

            #endregion

            routes.MapRoute(
                "Manage_Common",
                "Manage/Manage.aspx/{action}",
                new { controller = "Manage" }
            );

            routes.MapRoute(
                "Manage_ManageSettingsCommon",
                "Manage/ManageSettings.aspx/{action}",
                new { controller = "ManageSettings" }
            );

            routes.MapRoute(
                "Manage_AuxiliariesCommon",
                "Manage/Auxiliaries.aspx/{action}",
                new { controller = "Auxiliaries" }
            );

            #endregion

            routes.MapRoute(
                "Common",
                "{controller}.aspx/{action}",
                new { controller = "Channel", action = "Home" }

            );
        }

        public override void Init()
        {
            base.Init();

            //禁用FCNs
            PropertyInfo p = typeof(System.Web.HttpRuntime).GetProperty("FileChangesMonitor", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Static);
            object o = p.GetValue(null, null);
            FieldInfo f = o.GetType().GetField("_dirMonSubdirs", BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.IgnoreCase);
            object monitor = f.GetValue(o);
            MethodInfo m = monitor.GetType().GetMethod("StopMonitoring", BindingFlags.Instance | BindingFlags.NonPublic);
            m.Invoke(monitor, new object[] { });
        }

    }
}
