using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using System.Xml;

namespace SpaceBuilder.Web.Install
{
    public partial class Step2 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            ReExamine.Click += new EventHandler(ReExamine_Click);
            NextStep.Click += new EventHandler(NextStep_Click);

            bool error = false;

            if (CheckFolderWriteable(Server.MapPath("~/Uploads")))
            {
                Uploadstd.Attributes["class"] = "";
                UploadsExamine.Text = "/Uploadsļм";
                UploadsStatus.Text = "ɹ";
                UploadsSpan.Attributes["class"] = "detectionright";
            }
            else
            {
                error = true;
                Uploadstd.Attributes["class"] = "detectionError-font";
                UploadsExamine.Text = "/Uploadsļм";
                UploadsStatus.Text = "ʧ";
                UploadsSpan.Attributes["class"] = "detectionError";
            }

            if (CheckFolderWriteable(Server.MapPath("~/HttpCache")))
            {
                HttpCacheTd.Attributes["class"] = "";
                HttpCacheExamine.Text = "/HttpCacheļм";
                HttpCacheStatus.Text = "ɹ";
                HttpCacheSpan.Attributes["class"] = "detectionright";
            }
            else
            {
                error = true;
                HttpCacheTd.Attributes["class"] = "detectionError-font";
                HttpCacheExamine.Text = "/HttpCacheļм";
                HttpCacheStatus.Text = "ʧ";
                HttpCacheSpan.Attributes["class"] = "detectionError";
            }

            if (CheckFolderWriteable(Server.MapPath("~/Logs")))
            {
                LogsTd.Attributes["class"] = "";
                LogsExamine.Text = "/Logsļм";
                LogsStatus.Text = "ɹ";
                LogsSpan.Attributes["class"] = "detectionright";
            }
            else
            {
                error = true;
                LogsTd.Attributes["class"] = "detectionError-font";
                LogsExamine.Text = "/Logsļмʧ";
                LogsStatus.Text = "ʧ";
                LogsSpan.Attributes["class"] = "detectionError";
            }

            if (CheckFolderWriteable(Server.MapPath("~/IndexFiles")))
            {
                IndexFilestd.Attributes["class"] = "";
                IndexFilesExamine.Text = "/IndexFilesļм";
                IndexFilesStatus.Text = "ɹ";
                IndexFilesSpan.Attributes["class"] = "detectionright";
            }
            else
            {
                error = true;
                IndexFilestd.Attributes["class"] = "detectionError-font";
                IndexFilesExamine.Text = "/IndexFilesļм";
                IndexFilesStatus.Text = "ʧ";
                IndexFilesSpan.Attributes["class"] = "detectionError";
            }

            bool f35 = NETVersionChecker.CheckRequiredDOTNETVersion(new NETVersionChecker.DOTNETVersionInfo { FrameworkVersion = 3.5, ServicePack = 1 });
            bool f4 = NETVersionChecker.CheckRequiredDOTNETVersion(new NETVersionChecker.DOTNETVersionInfo { FrameworkVersion = 4.0 });

            if (f35 || f4)
            {
                FrameworkVersiontd.Attributes["class"] = "";
                FrameworkExamine.Text = "ѰװFramework汾" + (f35 ? "3.5sp1" : string.Empty) + (f4 ? ",4.0" : string.Empty);
                FrameworkStatus.Text = "ɹ";
                FrameworkVersion.Attributes["class"] = "detectionright";
                if (f4)
                {
                    Session["isTips"] = true;
                    Session["TipsContent"] = "ҪʹFramework4.0ҪWebļµweb4.0.config滻ԭweb.config";
                }
            }
            else
            {
                error = true;
                IndexFilestd.Attributes["class"] = "detectionError-font";
                IndexFilesExamine.Text = "ҪװFramework3.5 sp1ϰ汾";
                IndexFilesStatus.Text = "ʧ";
                IndexFilesSpan.Attributes["class"] = "detectionError";
            }


            System.IO.FileInfo FileInfo = new FileInfo(Server.MapPath("~/Web.config "));
            if (!FileInfo.Exists)
                throw new Exception(string.Format("ļ : {0} ", Server.MapPath("~/Web.config")));

            System.Xml.XmlDocument xmldocument = new System.Xml.XmlDocument();
            xmldocument.Load(FileInfo.FullName);
            try
            {
                XmlNode moduleNode = xmldocument.SelectSingleNode("//httpModules");
                if (moduleNode.HasChildNodes)
                {
                    for (int i = 0; i < moduleNode.ChildNodes.Count; i++)
                    {
                        XmlNode node = moduleNode.ChildNodes[i];
                        if (node.Name == "add")
                        {
                            if (node.Attributes.GetNamedItem("name").Value == "SpaceBuilderModule")
                            {
                                moduleNode.RemoveChild(node);
                                break;
                            }
                        }
                    }
                }

                xmldocument.Save(FileInfo.FullName);

                //ļд
                WebConfigExamine.Text = "~/Web.Config ";
                WebConfigStatus.Text = "ɹ";
                WebConfigtd.Attributes["class"] = "";
                WebConfigSpan.Attributes["class"] = "detectionright";
            }
            catch
            {
                //ļֻ
                error = true;
                WebConfigtd.Attributes["class"] = "detectionError-font";
                WebConfigExamine.Text = "ȡ ~/Web.Config ֻԲΪ˺Ȩޣ";
                WebConfigStatus.Text = "ʧ";
                WebConfigSpan.Attributes["class"] = "detectionError";
            }

            if (error)
            {
                ReExamine.Enabled = true;
                NextStep.Visible = false;
                Session["isTips"] = true;
            }
            else
            {
                ReExamine.Enabled = false;
                NextStep.Visible = true;
            }

        }

        bool CheckFolderWriteable(string path)
        {
            if (Directory.Exists(path) == false)
            {
                Directory.CreateDirectory(Server.MapPath(path));
                return true;
            }
            else
            {
                try
                {
                    string testFilePath = string.Format("{0}/test{1}{2}{3}{4}.txt", path, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second, DateTime.Now.Millisecond);
                    FileStream TestFile = System.IO.File.Create(testFilePath);
                    TestFile.WriteByte(Convert.ToByte(true));
                    TestFile.Close();
                    System.IO.File.Delete(testFilePath);
                    return true;
                }
                catch
                {
                    return false;
                }
            }
        }

        void ReExamine_Click(object sender, EventArgs e)
        {
            Page.Response.Redirect("~/Install/Step2.aspx");
        }

        void NextStep_Click(object sender, EventArgs e)
        {
            Page.Response.Redirect("~/Install/Step3_1.aspx");
        }
    }
}
