﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Step3_1.aspx.cs" Inherits="SpaceBuilder.Web.Install.Step3_1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<title>选择新建数据库还是使用现有数据库</title>
<link href="Style/Style.css" rel="stylesheet" type="text/css" />
</head>
<body class="tn-page-bg">
<form runat="server">
  <div class="tn-content">
    <div class="tn-head">
      <h1><span class="spb-logo">Spacebuilder</span> <em>v3.2</em></h1>
    </div>
    <div class="tn-body">
      <div class="tn-instructions">
        <div class="tn-progress-bar tn-widget-content tn-corner-all">
          <div style="width: 50%;" class="tn-progress-bar-value tn-widget-header tn-corner-left tn-border-tbl"> </div>
        </div>
        <ul class="tn-helper-clearfix">
          <li class="tn-step" style="width: 24.99%;"><b class="tn-widget-content tn-corner-all"> </b><span><a href="#">运行环境检测</a></span></li>
          <li class="tn-step tn-selected" style="width: 24.99%;"><b class="tn-widget-content tn-widget-header tn-corner-all"> </b><span><a href="#">安装数据库</a></span></li>
          <li class="tn-step" style="width: 24.99%;"><b class="tn-widget-content tn-corner-all"> </b><span><a href="#">数据库初始化</a></span></li>
          <li class="tn-step" style="width: 24.99%;"><b class="tn-widget-content tn-corner-all"> </b><span><a href="#">完成</a></span></li>
        </ul>
      </div>
      <div class="subcontainer">
        <table class="tn-table-grid">
          <tbody>
            <tr class="tn-table-grid-row">
              <td class="tn-width-category"> 数据库类型 </td>
              <td class="tn-width-action"> SQL2000,SQL2005及以上 </td>
              <td></td>
            </tr>
            <tr class="tn-table-grid-row">
              <td class="tn-width-category"> 数据库服务器 </td>
              <td colspan="2"><asp:TextBox runat="server" CssClass="textBox tn-border-gray tn-input-medium" ID="DBServerIP"></asp:TextBox>
                <span class="tn-Question-mark" title="1.若使用数据库不是默认端口则：IP:端口号，例如：（192.168.0.1:9001）2.若服务器上有多个实例则：IP\实例，例如：（192.168.0.1\9001）"> </span>
                <asp:RequiredFieldValidator ID="RequiredDBServerIP" runat="server" ValidationGroup="InstallGroup"
                                        CssClass="error" ControlToValidate="DBServerIP" ErrorMessage="请填写服务器IP"></asp:RequiredFieldValidator></td>
            </tr>
            <tr class="tn-table-grid-row">
              <td class="tn-width-category"> 数据库名称 </td>
              <td style="width: 155px"><asp:TextBox runat="server" CssClass="textBox tn-border-gray tn-input-medium" ID="DBName"></asp:TextBox>
                <span class="tn-Question-mark" title="1.选择创建数据库点提交是会创建新的2.如果使用程序创建数据库，数据库名称中间不能有“.” 或者数字开头"> </span></td>
              <td><asp:CheckBox value="1" Checked="false" ID="createNewDataBase" CssClass="tn-checkbox"
                                        runat="server" />
                创建新库
                <asp:RequiredFieldValidator ID="RequiredDBName" runat="server" ValidationGroup="InstallGroup"
                                        CssClass="error" ControlToValidate="DBName" ErrorMessage="请填写数据库名称"></asp:RequiredFieldValidator></td>
            </tr>
            <tr class="tn-table-grid-row">
              <td class="tn-width-category"> 数据库用户帐号 </td>
              <td colspan="2"><asp:TextBox runat="server" CssClass="textBox tn-border-gray tn-input-medium" ID="DBOwner"></asp:TextBox>
                <asp:RequiredFieldValidator ID="RequiredDBOwner" runat="server" ValidationGroup="InstallGroup"
                                        CssClass="error" ControlToValidate="DBOwner" ErrorMessage="请填写数据库用户帐号"></asp:RequiredFieldValidator></td>
              <td></td>
            </tr>
            <tr class="tn-table-grid-row">
              <td class="tn-width-category"> 数据库用户密码 </td>
              <td><asp:TextBox TextMode="Password" runat="server" CssClass="textBox tn-border-gray tn-input-medium"
                                        ID="DBOwenerPassWord"></asp:TextBox></td>
              <td><asp:CheckBox AutoPostBack="true" ID="isExpressly" CssClass="tn-checkbox" runat="server"
                                        OnCheckedChanged="isExpressly_CheckedChanged" />
                显示字符 </td>
            </tr>
            <tr class="tn-table-grid-row" id="tips" style="display: none">
              <td colspan="3"><span class="detectionHit"></span>此步骤需要时间较长，请耐心等待！执行成功后将自动跳转到下一页 </td>
            </tr>
            <tr class="tn-table-grid-row">
              <td colspan="3" class="detectionError-font"><span class="detectionError-font" id="errorfont">
                <asp:Literal runat="server" ID="Errors"></asp:Literal>
                </span>
                <asp:TextBox runat="server" ID="connectionStringText" Visible="false"></asp:TextBox></td>
            </tr>
            <tr class="tn-table-grid-row">
              <td align="right" colspan="3">
            </tr>
          </tbody>
        </table>
      </div>
    </div>
    <div class="tn-foot">
      <div class="tn-pagination"><span class="tn-button tn-button-primary" id="loadSpan" style="display: none;"><span
                                        class="tn-first-child"><a class="tn-page-next tn-page-thumb" href="javascript:;">执行中...</a></span></span> <span class="tn-button tn-button-primary"
                                            id="installspan"><span class="tn-first-child">
        <asp:LinkButton runat="server" CssClass="tn-page-next tn-page-thumb" ValidationGroup="InstallGroup"
                                                    OnClientClick="change(this)" ID="nextStep">安装</asp:LinkButton>
        </span></span>
        </td></div>
    </div>
  </div>
</form>
<script type="text/javascript">
        function change(obj) {
            var dBServerIP = document.getElementById('DBServerIP').value;
            var dBName = document.getElementById('DBName').value;
            var dBOwner = document.getElementById('DBOwner').value;
            if (dBName.length > 0 && dBServerIP.length > 0 && dBOwner.length > 0) {
                document.getElementById('installspan').style.display = "none";
                document.getElementById('loadSpan').style.display = "";
                document.getElementById('tips').style.display = "";
                document.getElementById('errorfont').innerHTML = "";
            }
        }
    </script>
</body>
</html>
