﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Xml;
using System.IO;
using System.Text;

namespace SpaceBuilder.Web.Install
{
    public partial class Step3_1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            nextStep.Click += new EventHandler(nextStep_Click);
        }

        void nextStep_Click(object sender, EventArgs e)
        {
            #region 新建数据库

            if (createNewDataBase.Checked)
            {
                string connectionStr = string.Format("server={0};uid={1};pwd={2};Trusted_Connection=no", DBServerIP.Text, DBOwner.Text, DBOwenerPassWord.Text);
                SqlConnection sqlCon = GetSqlConnection(connectionStr);
                if (sqlCon != null)
                {
                    string createDateBase = string.Format(" create database {0} ", DBName.Text);
                    SqlCommand createDBCommand = new SqlCommand(createDateBase, sqlCon);

                    //创建空数据库
                    try
                    {
                        createDBCommand.Connection.Open();
                        createDBCommand.ExecuteNonQuery();
                        sqlCon.Close();
                    }
                    catch (Exception cdbe)
                    {
                        Errors.Text = cdbe.Message;
                        return;
                    }
                }
            }

            #endregion

            #region 连接创建以及测试

            String writableConnection = string.Format("server={0};uid={1};pwd={2};Trusted_Connection=no;database={3}", DBServerIP.Text, DBOwner.Text, DBOwenerPassWord.Text, DBName.Text);
            String readOnlyConnection = string.Format("server={0};uid={1};pwd={2};Trusted_Connection=no;database={3}", DBServerIP.Text, DBOwner.Text, DBOwenerPassWord.Text, DBName.Text);

            SqlConnection writableSqlConnection = GetSqlConnection(writableConnection);

            if (writableSqlConnection == null)
            {
                Errors.Text = "创建连接失败";
                return;
            }

            try
            {
                writableSqlConnection.Open();
            }
            catch (Exception ex)
            {
                Errors.Text = ex.Message;
                return;
            }
            writableSqlConnection.Close();

            #endregion

            #region 编辑web.config

            //修改web.config文件
            try { SetWebConfig(writableConnection, readOnlyConnection); }
            catch { Errors.Text = "数据库安装成功，修改web.config 失败"; return; }


            #endregion

            #region 新建表和存储过程
            SqlConnection sqlConnection = GetSqlConnection(writableConnection);

            if (sqlConnection == null)
            {
                Errors.Text = "数据库创建成功，连接数据库失败！";
                return;
            }
            try
            {
                sqlConnection.Open();
            }
            catch (Exception e_cons)
            {
                Errors.Text = e_cons.Message;
                return;
            }
            sqlConnection.Close();

            //执行脚本 01_Install SpaceBuilder Schema.sql 完成数据库框架
            try { ExecuteInFile(sqlConnection, Server.MapPath("~/Install/SqlScripts/01_Install SpaceBuilder Schema.sql")); }
            catch (Exception cdse)
            {
                Errors.Text = "在文件：" + Server.MapPath("~/Install/SqlScripts/01_Install SpaceBuilder Schema.sql") + " 中产生异常。"; return;
            }

            connectionStringText.Text = writableConnection;

            #endregion

            Response.Redirect(string.Format("~/Install/Step3_2_1.aspx?connectionString={0}", connectionStringText.Text));
        }

        #region 工具方法

        //获取链接
        private SqlConnection GetSqlConnection(string ConnectionString)
        {
            try
            {
                return new SqlConnection(ConnectionString);
            }
            catch
            {
                return null;
            }
        }

        //设置web.config
        private void SetWebConfig(string writableConnection, string readOnlyConnection)
        {
            System.IO.FileInfo FileInfo = new FileInfo(Server.MapPath("~/web.config"));

            if (!FileInfo.Exists)
            {
                throw new Exception(string.Format("文件 : {0} 不存在", Server.MapPath("~/web.config")));
            }
            System.Xml.XmlDocument xmldocument = new System.Xml.XmlDocument();
            xmldocument.Load(FileInfo.FullName);


            bool FoundIt = false;
            XmlNode connNode = xmldocument.SelectSingleNode("//connectionStrings");


            if (connNode.HasChildNodes)
            {
                for (int i = 0; i < connNode.ChildNodes.Count; i++)
                {
                    XmlNode Node = connNode.ChildNodes[i];
                    if (Node.Name == "add")
                    {
                        try
                        {
                            if (Node.Attributes.GetNamedItem("name").Value == "writableConnection")
                            {
                                Node.Attributes.GetNamedItem("connectionString").Value = writableConnection;
                            }
                            else if (Node.Attributes.GetNamedItem("name").Value == "readOnlyConnection")
                            {
                                Node.Attributes.GetNamedItem("connectionString").Value = readOnlyConnection;
                            }

                            FoundIt = true;
                        }
                        catch (Exception e)
                        {
                            FoundIt = true;
                        }
                    }
                }

                if (!FoundIt)
                {
                    throw new Exception("修改 web.config 时出错");
                }

                xmldocument.Save(FileInfo.FullName);
            }


        }

        //执行sql脚本
        private void ExecuteInFile(SqlConnection sqlCon, string pathToScriptFile)
        {
            string sqlString = "";
            StreamReader reader = null;
            if (!System.IO.File.Exists(pathToScriptFile))
            {
                throw new Exception("文件" + pathToScriptFile + " 未找到!");
            }
            Stream stream = System.IO.File.OpenRead(pathToScriptFile);
            reader = new StreamReader(stream);
            SqlCommand command = new SqlCommand();
            sqlCon.Open();

            command.Connection = sqlCon;
            command.CommandType = System.Data.CommandType.Text;
            while (null != (sqlString = ReadNextFromStream(reader)))
            {
                command.CommandText = sqlString;
                command.ExecuteNonQuery();

            }
            reader.Close();
            sqlCon.Close();
        }

        //读取文件中的下一行
        private string ReadNextFromStream(StreamReader reader)
        {
            StringBuilder stringBuilder = new StringBuilder();
            string textLine;
            while (true)
            {
                textLine = reader.ReadLine();
                if (textLine == null)
                {
                    if (stringBuilder.Length > 0)
                    {
                        return stringBuilder.ToString();
                    }
                    else
                    {
                        return null;
                    }
                }
                if (textLine.TrimEnd().ToUpper() == "GO")
                {
                    break;
                }
                stringBuilder.AppendFormat("{0}\r\n", textLine);
            }
            return stringBuilder.ToString();
        }

        #endregion

        protected void isExpressly_CheckedChanged(object sender, EventArgs e)
        {

            if (((CheckBox)sender).Checked)
                DBOwenerPassWord.TextMode = TextBoxMode.SingleLine;
            else
                DBOwenerPassWord.TextMode = TextBoxMode.Password;
        }
    }
}
