﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Data.SqlClient;
using System.Xml;
using System.IO;
using System.Text;

namespace SpaceBuilder.Web.Install
{
    public partial class Step3_2_2 : System.Web.UI.Page
    {
        private string connectionString = string.Empty;

        protected void Page_Load(object sender, EventArgs e)
        {
            connectionString = Request.QueryString.GetString("connectionString", string.Empty);
            nextStep.Click += new EventHandler(nextStep_Click);
            exec.Click += new EventHandler(exec_Click);
            if (IpDatas.Checked)
                exec.Visible = true;

        }

        void exec_Click(object sender, EventArgs e)
        {
            SqlConnection sqlConnection = GetSqlConnection(connectionString);

            if (sqlConnection == null)
            {
                Errors.Text = "创建连接失败";
                return;
            }
            try
            {
                sqlConnection.Open();
            }
            catch (Exception)
            {
                Errors.Text = "创建连接失败！连接字符串有误";
                return;
            }
            sqlConnection.Close();

            if (IpDatas.Checked)
            {
                //执行脚本 03_Install initial Data.sql 初始化数据
                try { ExecuteInFile(sqlConnection, Server.MapPath("~/Install/SqlScripts/03_Install IP initial Data.sql")); }
                catch { Errors.Text = "在文件：" + Server.MapPath("~/Install/SqlScripts/03_Install IP initial Data.sql") + " 中产生异常。"; return; }
            }

            Response.Redirect("~/Install/Succeed.aspx");
        }
        void nextStep_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Install/Succeed.aspx");
        }

        #region 工具方法

        //获取链接
        private SqlConnection GetSqlConnection(string ConnectionString)
        {
            try
            {
                return new SqlConnection(ConnectionString);
            }
            catch
            {
                return null;
            }
        }

        //执行sql脚本
        private void ExecuteInFile(SqlConnection sqlCon, string pathToScriptFile)
        {
            string sqlString = "";
            StreamReader reader = null;
            if (!System.IO.File.Exists(pathToScriptFile))
            {
                throw new Exception("文件" + pathToScriptFile + " 未找到!");
            }
            Stream stream = System.IO.File.OpenRead(pathToScriptFile);
            reader = new StreamReader(stream);
            SqlCommand command = new SqlCommand();
            try
            {
                sqlCon.Open();
            }
            catch
            {
                Errors.Text = "连接打开失败，请检查连接字符串是否正确。";
                return;
            }

            command.Connection = sqlCon;
            command.CommandType = System.Data.CommandType.Text;
            while (null != (sqlString = ReadNextFromStream(reader)))
            {
                command.CommandText = sqlString;
                try
                {
                    command.ExecuteNonQuery();
                }
                catch (Exception e)
                {
                    Response.Write(e.Message);
                }
            }
            reader.Close();
            sqlCon.Close();
        }

        //读取文件中的下一行
        private string ReadNextFromStream(StreamReader reader)
        {
            StringBuilder stringBuilder = new StringBuilder();
            string textLine;
            while (true)
            {
                textLine = reader.ReadLine();
                if (textLine == null)
                {
                    if (stringBuilder.Length > 0)
                    {
                        return stringBuilder.ToString();
                    }
                    else
                    {
                        return null;
                    }
                }
                if (textLine.TrimEnd().ToUpper() == "GO")
                {
                    break;
                }
                stringBuilder.AppendFormat("{0}\r\n", textLine);
            }
            return stringBuilder.ToString();
        }

        #endregion
    }
}
