﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogThread>>" %>
<% BlogThreadSortBy currentSortBy = ViewData.Get<BlogThreadSortBy>("currentSortBy", BlogThreadSortBy.MostRecent);
   int categoryID = Html.GetParameterFromRouteDateOrQueryString("categoryID", 0);
   string tagName = Html.GetParameterFromRouteDateOrQueryString("tagName");
   int BlogApplicationID = ApplicationIDs.Instance().Blog();
%>

<div id="listBlogThreadsDiv">
  <div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom"> <span class="tn-count tn-text-note tn-helper-right"> <%=string.Format(GetResourceString("Description_Pattern_AllArticle", BlogApplicationID), Model.TotalRecords.ToString())%></span> <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon") %> <span class="tn-action"><a href="javascript:;" onclick="loadToSummaryBlogThreads()"> <%=GetResourceString("Action_Summary")%></a></span><span class="tn-action"><%=GetResourceString("Action_List")%></span> </div>
  </div>
  <% if (Model.Records != null && Model.TotalRecords > ((categoryID > 0) ? 1 : 0))
       {%>
  <table class="tn-table-grid">
    <tr class="tn-table-grid-header">
      <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Subject")%> </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_Author")%> </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Common_Rating")%> </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Common_Comment") %> </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Common_Browse") %> </th>
      <th class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_PostDate")%> </th>
    </tr>
    <% for (int i = (categoryID > 0) ? 1 : 0; i < Model.Records.Count; i++)
           {
               BlogThread blogThread = Model.Records[i];
               if (blogThread.Owner == null)
                   continue;                           
        %>
    <tr class="tn-table-grid-row">
      <td class="tn-border-gray tn-border-bottom"><a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID),blogThread) %>" target="_blank" title="<%=blogThread.Subject %>"> <%=StringUtils.Trim(blogThread.Subject,20)%></a></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=SPBHtmlHelper.Instance().UserDisplayNameLink(blogThread.OwnerUserID,blogThread.Author,ApplicationIDs.Instance().Blog()) %></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=SPBHtmlHelper.Instance().ShowRating(blogThread.RatingSum, blogThread.TotalRatings)%></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=blogThread.CommentCount.ToString()%></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=blogThread.HitTimes.ToString()%></td>
      <td class="tn-border-gray tn-border-bottom tn-nowrap"><%=Formatter.FormatDate(blogThread.PostDate.Date, false)%></td>
    </tr>
    <% }%>
  </table>
  <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListBlogThreads", "ChannelBlog", new RouteValueDictionary { { "sortBy", currentSortBy }, { "categoryID", categoryID }, { "tagName", WebUtils.UrlEncode(tagName) }, { "pageIndex", "{0}" } }), "pageIndexChange")%> </div>
  <%} %>
  <script type="text/javascript">
        function pageIndexChange(url) {
            $('#listBlogThreadsDiv').parent().load(url);
        }

        function loadToSummaryBlogThreads() {
            $('#listBlogThreadsDiv').parent().load('<%=SPBUrlHelper.Action("Control_SummaryBlogThreads","ChannelBlog",new RouteValueDictionary{{"sortBy",currentSortBy},{"categoryID",categoryID},{"tagName",WebUtils.UrlEncode(tagName)},{"pageIndex",1}}) %>');
        }
    </script>
</div>
