﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<BlogThread>>" %>
<% SiteCategory siteCategory = (SiteCategory)ViewData["siteCategory"];
   string titleName = ViewData.GetString("titleName", siteCategory.GetMultilingualCategoryName(CurrentUserLanguage));
%>
<% if (Model != null && Model.Count > 0)
   {
       BlogThread firstBlogThread = Model[0];
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-article-categories-top">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=titleName%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-helper-clearfix tn-list tn-list-symmetry">
      <li class="tn-helper-clearfix tn-list-first">
        <% if (firstBlogThread.HasManagerFeaturedImage)
                   {%>
        <div class="tn-list-item-area-left"> <a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(firstBlogThread.OwnerUserID),firstBlogThread)%>"> <img src=" <%=SiteUrls.Instance().BlogPhotoUrl(firstBlogThread.UserFeaturedImageAttachmentID, BlogPhotoTypes.Title) %>" /></a> </div>
        <%} %>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(firstBlogThread.OwnerUserID),firstBlogThread)%>" target="_blank" title="<%=firstBlogThread.Subject %>"> <%=StringUtils.Trim(firstBlogThread.Subject, 15)%></a> </h5>
          </div>
          <div class="tn-list-item-row"> <cite class="tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(firstBlogThread.OwnerUserID,firstBlogThread.Author,ApplicationIDs.Instance().Blog()) %> </cite><em class="tn-date tn-text-note"> <%=Formatter.FormatFriendlyDate(firstBlogThread.PostDate)%></em> </div>
          <div class="tn-list-item-row tn-list-item-summary">
            <p class="tn-helper-reset"> <%=HtmlUtils.TrimHtml(firstBlogThread.GetBody(false), 65)%></p>
          </div>
        </div>
      </li>
      <% 
                for (int i = 1; i < Model.Count; i++)
                {
                    BlogThread blogThread = Model[i];
                    if (blogThread.Owner == null)
                        continue;
            %>
      <%if (blogThread != null)
              { %>
      <li><cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(blogThread.Owner) %> </cite><a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID),blogThread)  %>" target="_blank" title="<%=blogThread.Subject %>"> <%=StringUtils.Trim(blogThread.Subject,50)%></a> </li>
      <%}
                }%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ListBlogThreadsByCategory","ChannelBlog",new RouteValueDictionary{{"categoryID",siteCategory.CategoryID}}) %>"> <%=GetResourceString("Action_More")%></a></p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
