﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<BlogThread>>" %>
<ol class="tn-helper-reset tn-list tn-list-rank tn-img-sprite">
    <% 
        BlogThreadSortBy sortBy = (BlogThreadSortBy)ViewData["blogThreadSortBy"];
        if (Model != null && Model.Count > 0)
        {
            foreach (BlogThread blogThread in Model)
            {
    %>
    <li><em class="tn-count tn-text-note tn-helper-right">
        <% switch (sortBy)
           {
               case BlogThreadSortBy.MostRecent:
                   Response.Write(Formatter.FormatDateToIntervalTime(blogThread.PostDate));
                   break;
               case BlogThreadSortBy.TotalRatings:
                   Response.Write(blogThread.RatingSum.ToString());
                   break;
               case BlogThreadSortBy.TotalReplies:
                   Response.Write(blogThread.CommentCount.ToString());
                   break;
               case BlogThreadSortBy.TotalViews:
                   Response.Write(blogThread.HitTimes.ToString());
                   break;
               default:
                   break;
           }%></em> <a href="<%=SPBUrlHelper.Action("ShowBlogThread","Blog",new RouteValueDictionary{{"userDomainName",UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID)},{"threadID",blogThread.ThreadID}}) %>"
                   title="<%=blogThread.Subject %>" target="_blank">
                   <%=HtmlUtils.TrimHtml(blogThread.Subject,13) %></a></li>
    <%}
            } %>
</ol>
<% int categoryID = ViewData.GetInt("categoryID", 0); %>
<br />
<p class="tn-helper-align-right">
    <a href="<%=SPBUrlHelper.Action("BlogThreadRanks","ChannelBlog",new RouteValueDictionary{{"rankBy",sortBy},{"categoryID",categoryID},{"pageIndex",1}}) %>">
        <%=GetResourceString("Action_More")%></a>
</p>
