﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<BlogSection>>" %>
<% int BlogApplicationID = ApplicationIDs.Instance().Blog(); %>
<% if (Model.Count > 0)
   {%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-new-blogger">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_NewBlog", BlogApplicationID)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-avatar-list">
      <% if (Model != null && Model.Count > 0)
               {
                   foreach (BlogSection blogSection in Model)
                   {
                       if (blogSection.Owner == null)
                           continue;
            %>
      <li class="tn-avatar-item">
        <div class="tn-avatar"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(blogSection.OwnerUserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%> </div>
        <a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName",blogSection.Owner.UserName } })%>"
                    target="_blank" class="tn-text-heading"> <%=blogSection.SectionName %></a> </li>
      <% }
               } %>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("BlogRanks","ChannelBlog",new RouteValueDictionary{{"sortBlogsBy",BlogSectionSortBy.CreateDate}}) %>"> <%=GetResourceString("Action_More")%></a> </p>
  </div>
</div>
<%} %>
