﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<BlogSection>>" %>
<% BlogSectionSortBy sortBy = (BlogSectionSortBy)ViewData["sortBy"];
   int i = 0; %>
<ol class="tn-helper-reset tn-list tn-list-rank tn-img-sprite">
    <% if (Model != null && Model.Count > 0)
       {
           foreach (BlogSection blogSection in Model)
           {
               if (blogSection.Owner == null)
                   continue;
               i++;%>
    <li><em class="tn-count tn-text-note tn-helper-right">
        <% switch (sortBy)
           {
               case BlogSectionSortBy.CommentCount:
                   Response.Write(blogSection.CommentCount.ToString());
                   break;
               case BlogSectionSortBy.CreateDate:
                   Response.Write(Formatter.FormatDate(blogSection.DateCreated,false));
                   break;
               case BlogSectionSortBy.HitTimes:
                   Response.Write(blogSection.HitTimes.ToString());
                   break;
               case BlogSectionSortBy.Points:
                   Response.Write(blogSection.Points.ToString());
                   break;
               case BlogSectionSortBy.ThreadCount:
                   Response.Write(blogSection.ThreadCount.ToString());
                   break;
               case BlogSectionSortBy.StageHitTimes:
                   Response.Write(blogSection.StageHitTimes.ToString());
                   break;
               default:
                   break;
           } %></em> <a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName",blogSection.Owner.UserName } })%>" title="<%=blogSection.SectionName %>"
               target="_blank">
               <%=StringUtils.Trim(blogSection.SectionName,18) %></a></li>
    <%}
       } %>
</ol>
<%if (i == Model.Count)
  { %>
<br />
<p class="tn-helper-align-right">
    <a href="<%=SPBUrlHelper.Action("BlogRanks","ChannelBlog",new RouteValueDictionary{{"sortBlogsBy",sortBy},{"pageIndex",1}}) %>">
        <%=GetResourceString("Action_More")%></a></p>
<%} %>
