﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<BlogThread>>" %>
<spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/plugin/jquery.slideshow.lite-0.5.3.js"
    SetExpireDays="30" />
<%if (Model != null && Model.Count > 0)
  { %>
<% IList<BlogThread> commendBlogThreads = ViewData.Get<IList<BlogThread>>("commendBlogThreads", new List<BlogThread>()); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-focus-articles">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_FocusArticle", ApplicationIDs.Instance().Blog())%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <div class="tn-helper-clearfix">
      <% if (commendBlogThreads != null && commendBlogThreads.Count > 0)
               {%>
      <div id="commendBlogThreadsSlideShow">
        <%   foreach (BlogThread blogThread in commendBlogThreads)
                     {
                         if (blogThread.UserFeaturedImageAttachmentID > 0)
                         {
                %>
        <a style="display: none" href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID),blogThread)%>" target="_blank"> <img src="<%=SiteUrls.Instance().BlogPhotoUrl(blogThread.ManagerFeaturedImageAttachmentID, BlogPhotoTypes.Slide) %>" alt="<%=HtmlUtils.TrimHtml(blogThread.Subject,20) %>" title="<%=HtmlUtils.TrimHtml(blogThread.Subject,20) %>" rel="<%=SPBUrlHelper.Action("ShowBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID) }, { "threadID", blogThread.ThreadID } })%>" /> </a>
        <% }
                     }%>
      </div>
      <%}%>
      <ul class="tn-list tn-helper-flowfix">
        <li class="tn-helper-clearfix tn-list-first">
          <% BlogThread firstBlogThread = Model[0];
                       if (firstBlogThread != null)
                       {
                           int subjectLength = 85; 
                           if (firstBlogThread.UserFeaturedImageAttachmentID > 0)
                           {
                               subjectLength = 60;
                               %>
          <div class="tn-list-item-area-left"><a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(firstBlogThread.OwnerUserID),firstBlogThread)%>" target="_blank"><img src="<%=SiteUrls.Instance().BlogPhotoUrl(firstBlogThread.UserFeaturedImageAttachmentID, BlogPhotoTypes.Title) %>" /></a></div>
          <%} %>
          <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
              <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(firstBlogThread.OwnerUserID),firstBlogThread)%>" target="_blank" title="<%=firstBlogThread.Subject %>"> <%=StringUtils.Trim(firstBlogThread.Subject, 50)%></a> </h5>
            </div>
            <div class="tn-list-item-row"><cite class="tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(firstBlogThread.OwnerUserID,firstBlogThread.Author,ApplicationIDs.Instance().Blog())%></cite><em class="tn-date tn-text-note"> <%=Formatter.FormatFriendlyDate(firstBlogThread.PostDate)%></em> </div>
            <div class="tn-list-item-row tn-list-item-summary">
              <p class="tn-helper-reset">
                <%if (string.IsNullOrEmpty(firstBlogThread.ForcedExcerpt)) Response.Write(HtmlUtils.TrimHtml(firstBlogThread.GetBody(false), subjectLength)); else Response.Write(HtmlUtils.TrimHtml(firstBlogThread.ForcedExcerpt, subjectLength));%>
              </p>
            </div>
          </div>
        </li>
        <%} %>
        <% for (int i = 1; i < Model.Count; i++)
                   {
                       BlogThread blogThread = Model[i];
                %>
        <li><cite class="tn-helper-right tn-secondary-text"> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(blogThread.OwnerUserID, blogThread.Author, ApplicationIDs.Instance().Blog())%> </cite>
          <% if (blogThread.SiteCategoryID > 0 && blogThread.SiteCategory != null)
                       {  %>
          <a class="tn-secondary-text tn-category" href="<%=SPBUrlHelper.Action("ListBlogThreadsByCategory","ChannelBlog",new RouteValueDictionary{{"categoryID",blogThread.SiteCategoryID}}) %>"> 【<%=blogThread.SiteCategory.CategoryName%>】 </a>
          <%} %>
          <a href="<%=SPBUrlHelper.Action("ShowBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID) }, { "threadID", blogThread.ThreadID } })%>" target="_blank" title="<%=blogThread.Subject %>"> <%=StringUtils.Trim(blogThread.Subject,50) %> </a></li>
        <% } %>
      </ul>
    </div>
  </div>
</div>
<div class="tn-blank10"> </div>
<% }%>
<script type="text/javascript">
    $(document).ready(function() {
        $("#commendBlogThreadsSlideShow a").show();
        $("#commendBlogThreadsSlideShow").slideshow({ width: 320, height: 240 });
    });
</script>
