﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<BlogThread>>" %>
<% BlogThreadSortBy currentSortBy = ViewData.Get<BlogThreadSortBy>("currentSortBy", BlogThreadSortBy.MostRecent);
   int categoryID = ViewData.GetInt("categoryID", 0);
   string tagName = ViewData.GetString("tagName", string.Empty);
   int BlogApplicationID = ApplicationIDs.Instance().Blog();%>
<script type="text/javascript">
    function pageIndexChange(url) {
        $('#summaryBlogThreadsDiv').parent().load(url);
    }

    function loadToListBlogThreads() {
        $('#summaryBlogThreadsDiv').parent().load('<%=SPBUrlHelper.Action("Control_ListBlogThreads","ChannelBlog",new RouteValueDictionary{{"sortBy",currentSortBy},{"categoryID",categoryID},{"tagName",WebUtils.UrlEncode(tagName)},{"pageIndex",1}}) %>');
    }
                  
</script>

<div id="summaryBlogThreadsDiv">
  <%if (Model.TotalRecords > 0)
      { %>
  <div class="tn-list-header">
    <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom"> <span class="tn-count tn-text-note tn-helper-right"> <%=string.Format(GetResourceString("Description_Pattern_AllArticle", BlogApplicationID), Model.TotalRecords.ToString())%></span> <%=GetResourceString("Label_Display")%><%=GetResourceString("Common_Colon")%> <span class="tn-action"><%=GetResourceString("Action_Summary")%></span> <span class="tn-action"><a href="javascript:;" onclick="loadToListBlogThreads()"> <%=GetResourceString("Action_List")%> </a></span> </div>
  </div>
  <ul class="tn-list">
    <% if (Model.Records != null && Model.TotalRecords > 0)
           {
               for (int i = (categoryID > 0) ? 1 : 0; i < Model.Records.Count; i++)
               {
                   BlogThread fdsfsf = Model.Records[0];
                   BlogThread blogThread = Model.Records[i];

        %>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
      <% if (blogThread.UserFeaturedImageAttachmentID > 0)
               { %>
      <div class="tn-list-item-area-left"> <img src="<%=SiteUrls.Instance().BlogPhotoUrl(blogThread.UserFeaturedImageAttachmentID, BlogPhotoTypes.Title) %>" /> </div>
      <%} %>
      <div class="tn-list-item-area-main">
        <div class="tn-list-item-row tn-list-item-heading">
          <h5> <a href="<%=SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID),blogThread) %>"
                            target="_blank" title="<%=blogThread.Subject%>"> <%=StringUtils.Trim(blogThread.Subject,35)%></a>
            <% if (blogThread.IsEssential)
                           {%>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
            <%}
                           if (blogThread.SpecialOrder > 0)
                           {%>
            <%=SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", "tn-icon-inline" } })%>
            <%}%>
          </h5>
        </div>
        <div class="tn-list-item-row tn-list-item-summary">
          <p>
            <%if (string.IsNullOrEmpty(blogThread.Excerpt)) Response.Write(HtmlUtils.TrimHtml(blogThread.GetBody(false), 90)); else Response.Write(HtmlUtils.TrimHtml(blogThread.Excerpt, 90));%>
          </p>
        </div>
        <div class="tn-list-item-row"> <cite> <%=SPBHtmlHelper.Instance().UserDisplayNameLink(blogThread.OwnerUserID, blogThread.Author, ApplicationIDs.Instance().Blog())%> </cite><cite class="tn-text-note"><em> <%=Formatter.FormatFriendlyDate(blogThread.PostDate)%></em></cite> <cite class="tn-text-note"> <%=SPBHtmlHelper.Instance().ShowRating(blogThread.RatingSum, blogThread.TotalRatings)%></cite>
          <% string title = string.Empty;
                       if (blogThread.BlogSection.EnableComments)
                       {
                           title = GetResourceString("Common_Comment") + " (" + blogThread.CommentCount + ")";
                       }
                       else
                       {
                           title = GetResourceString("Label_CloseComment", BlogApplicationID);
                       } %>
          <%=SPBHtmlHelper.Instance().LinkButton("comment", title, SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID), blogThread) + "#Comment", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%> <%=SPBHtmlHelper.Instance().LinkButton("browser", GetResourceString("Common_Browse") + " (" + blogThread.HitTimes + ")", SiteUrls.Instance().ShowBlogThread(UserID2UserNameDictionary.GetUserName(blogThread.OwnerUserID), blogThread), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%> </div>
      </div>
    </li>
    <% }
           } %>
  </ul>
  <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_SummaryBlogThreads", "ChannelBlog", new RouteValueDictionary { { "sortBy", currentSortBy }, { "categoryID", categoryID }, { "tagName", WebUtils.UrlEncode(tagName) }, { "pageIndex", "{0}" } }), "pageIndexChange")%> </div>
  <%}
      else
      {%>
  <div>
    <%if (categoryID > 0)
          {%>
    当前类别下没有文章
    <%}
          else if (!string.IsNullOrEmpty(tagName))
          { %>
    当前标签下没有文章
    <%}%>
  </div>
  <%} %>
</div>
