﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% ChannelClubSubMenu? subMenu = (ChannelClubSubMenu?)ViewData["currentSubMenu"];
   ViewData["currentSubMenu"] = null;
   
   int applicationId = ApplicationIDs.Instance().Club();
%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu sf-js-enabled sf-shadow">
            <li <% if (subMenu == ChannelClubSubMenu.Home) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ChannelClubHome()) %>">
                    <%=GetResourceString("Navigation_ClubHome", applicationId)%></a></li>
            <li <% if (subMenu == ChannelClubSubMenu.Rank) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ClubRanks","ChannelClub")) %>">
                    <%=GetResourceString("Navigation_ClubRank", applicationId)%></a></li>
            <li <% if (subMenu == ChannelClubSubMenu.Search) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelClub")) %>">
                    <%=GetResourceString("Title_ClubSearch", applicationId)%></a></li>
            <% if (CurrentUser != null)
               { %>
            <li class="spb-nav-item"><a target="_blank" href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ListMyClubs", "ClubUserDomain", new RouteValueDictionary { { "userDomainName",CurrentUser.UserName }}))%>">
                <%=GetResourceString("Navigation_MyClub", applicationId)%></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <% if (ClubPermission.Validate(new Club(), Globals.GetCurrentUser(), PermissionItemKeys.Instance().CreateClub()))
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_CreateNewClub", applicationId), Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("NewClub", "ChannelClub")), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
        </div>
        <spb:BreadCrumb ID="BreadCrumb1" runat="server" />
    </div>
</div>
