﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<ClubAreaStatistics>>" %>
<% int applicationId = ApplicationIDs.Instance().Club();
   if (Model != null)
   { %>
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    int maxShowDictionaryCount = 5;
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-category-nav-col">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Navigation_Area",EventApplicationID) %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <div class="tn-directory" id="allAreasList">
            <% int t = 1;
               foreach (ClubAreaStatistics parentArea in Model)
               {
            %>
            <div name="moreAreasItem" <% if(t>=maxShowDictionaryCount) Response.Write("style=\"display:none\""); %>>
                <h5 class="tn-directory-path">
                    <a title="<%=parentArea.Name%>" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",parentArea.AreaCode}}) %>">
                        <%=StringUtils.Trim(parentArea.Name,8)%></a></h5>
                <%if (parentArea.Childs != null && parentArea.Childs.Count > 0)
                  { %>
                <div class="tn-directory-level">
                    <% int i = 1;
                       foreach (ClubAreaStatistics areChild in parentArea.Childs)
                       {
                           if (i > 5) break; %>
                    <span class="tn-directory-item"><a title="<%=areChild.Name%>" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",areChild.AreaCode}}) %>">
                        <%=StringUtils.Trim(areChild.Name,8)%></a> <em class="tn-text-note">
                            <%=areChild.CumulateTotalCount%></em></span>
                    <%i++;
                       } %>
                    <span class="tn-directory-item"><a id="areaText" href="<%=SPBUrlHelper.Action("Search","ChannelClub",new RouteValueDictionary{{"areaCode",parentArea.AreaCode}}) %>">
                        <%=GetResourceString("Action_More")%></a></span>
                </div>
                <%} t++;%>
            </div>
            <%}%>
            <%if (Model.Count >= maxShowDictionaryCount)
              {%>
            <p class="tn-helper-align-right">
                <span class="tn-action tn-action-text-icon-right"><span id="span-moreAreas" class="tn-icon tn-icon-triangle-down">
                </span><a id="moreAreas" href="javascript:;" class="tn-action-text">
                    <%=GetResourceString("Action_OpenMoreArea", EventApplicationID)%></a> </span>
            </p>
            <%} %>
        </div>
    </div>
</div>
 <script type="text/javascript">
     $(document).ready(function() {
         $("#moreAreas").click(function() {
             var $moreAreas = $('#allAreasList > div[name="moreAreasItem"]:gt(<%=maxShowDictionaryCount-2 %>)');
             $moreAreas.toggle();
             if ($moreAreas.is(":visible")) {
                 $(this).text('<%=GetResourceString("Action_EasyArea", EventApplicationID)%>');
                 $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-up" });
             }
             else {
                 $(this).text('<%=GetResourceString("Action_OpenMoreArea", EventApplicationID)%>');
                 $("#span-moreAreas").attr({ className: "tn-icon tn-icon-triangle-down" });
             };
         });

     });
</script>
<%} %>
