﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<SiteCategory>>" %>
<% int applicationId = ApplicationIDs.Instance().Club(); %>
<%int EventApplicationID = ApplicationIDs.Instance().Event();
  int maxShowCategoryesCount = 5; %>
<% if (Model != null)
   {
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-category-nav-col"
    id="allCategory">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Navigation_Category",EventApplicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <div class="tn-directory" id="allCategoryList">
            <%  int t = 1;
                foreach (SiteCategory parentCategory in Model)
                {
            %>
            <div name="moreCategoryItem" <% if(t>=maxShowCategoryesCount) Response.Write("style=\"display:none\""); %>>
                <h5 class="tn-directory-path">
                    <a title="<%=parentCategory.CategoryName%>" href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "categoryID", parentCategory.CategoryID } })%>">
                        <%=StringUtils.Trim(parentCategory.CategoryName,8)%>
                    </a>
                </h5>
                <%if (parentCategory.Childs != null && parentCategory.Childs.Count > 0)
                  { %>
                <div class="tn-directory-level">
                    <% int i = 1;
                       foreach (SiteCategory category in parentCategory.Childs)
                       {
                           if (i > 5) break; %>
                    <span class="tn-directory-item"><a title="<%=category.CategoryName%>" href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "categoryID", category.CategoryID } })%>">
                        <%=StringUtils.Trim(category.CategoryName,8)%></a> <em class="tn-text-note">
                            <%=category.CumulateItemCount%></em></span>
                    <%i++;
                       } %>
                    <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "categoryID", parentCategory.CategoryID } })%>">
                        <%=GetResourceString("Action_More")%></a></span>
                </div>
                <%} t++;%>
            </div>
            <%}%>
            <br />
            <%if (Model.Count >= maxShowCategoryesCount)
              {%>
            <p class="tn-helper-align-right">
                <span class="tn-action tn-action-text-icon-right"><span id="span-morecategory" class="tn-icon tn-icon-triangle-down">
                </span><a id="morecategory" href="javascript:;" class="tn-action-text">
                    <%=GetResourceString("Action_OpenMoreClass", EventApplicationID)%></a> </span>
            </p>
            <%} %>
        </div>
    </div>
</div>


 <script type="text/javascript">
     $(document).ready(function() {
         $("#morecategory").click(function() {
             var $moreCategories = $('#allCategoryList > div[name="moreCategoryItem"]:gt(<%=maxShowCategoryesCount-2 %>)');
             $moreCategories.toggle();
             if ($moreCategories.is(":visible")) {
                 $(this).text('<%=GetResourceString("Action_EasyClass", EventApplicationID)%>');
                 $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-up" });
             }
             else {
                 $(this).text('<%=GetResourceString("Action_OpenMoreClass", EventApplicationID)%>');
                 $("#span-morecategory").attr({ className: "tn-icon tn-icon-triangle-down" });
             };
         });
     });
</script>
<%} %>