﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<Club>>" %>
<%ClubsSortBy sortBy = (ClubsSortBy)ViewData["sortBy"];
  int applicationId = ApplicationIDs.Instance().Club(); %>
<div class="clubList">
    <%if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
      {
          foreach (var club in ViewData.Model.Records)
          {%>
    <div class="clubItem clearfix">
        <span class="headPhoto"><a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank"><%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID,ClubLogoSizeTypes.Small,new RouteValueDictionary {{"alt",club.ClubName}}) %><span class="smooth"></span></a></span>
        <div class="info">
            <h4>
                <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                    <%=club.ClubName %></a></h4>
            <div>
                <span><em><%=GetResourceString("Label_ClubOwner", applicationId)%><%=GetResourceString("Common_Colon") %></em><a href="<%=SiteUrls.Instance().UserChannelHome(club.ClubOwnerUserID, UserDomainSpecialAppIDs.Instance().Home()) %>"
                    target="_blank"><%=SPBHtmlHelper.Instance().UserDisplayName(club.ClubOwner.UserID) %></a></span><span><em><%=GetResourceString("Label_ClubCreateDate", applicationId)%><%=GetResourceString("Common_Colon") %></em><%=Formatter.FormatDate(club.DateCreated) %></span><span><em><%=GetResourceString("Label_ClubPublic", applicationId)%><%=GetResourceString("Common_Colon") %></em>
                        <% if (club.IsPublic) Response.Write(GetResourceString("Description_IsPublic", applicationId)); else Response.Write(GetResourceString("Description_IsPrivate", applicationId)); %>
                    </span>
                  <%if (!string.IsNullOrEmpty(club.AreaCode))
                    {%>
                <a href="<%=SPBUrlHelper.Action("ListClubsByArea","ChannelClub",new RouteValueDictionary{{"areaCode",club.AreaCode}}) %>"><%=Formatter.FormatArea(club.AreaCode, true)%></a>
                <%} %>
            </div>
            <div>
                <span><em><%=GetResourceString("Label_ClubMemberCount", applicationId)%><%=GetResourceString("Common_Colon") %></em><%=club.MemberCount %></span><span><em><%=GetResourceString("Label_HitTimes", applicationId)%><%=GetResourceString("Common_Colon") %></em><%=club.HitTimes %></span><span><em><%=GetResourceString("Label_WeekHitTimes", applicationId)%><%=GetResourceString("Common_Colon") %></em><%=club.StageHitTimes %></span><span><em><%=GetResourceString("Label_Points", applicationId)%><%=GetResourceString("Common_Colon") %></em><%=club.Points %></span></div>
            <p>
                <%=HtmlUtils.TrimHtml(club.Brief,150) %>
            </p>
        </div>
    </div>
    <%}
      }%>
</div>
<%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
  {%>
<div class="tn-pagination tn-helper-align-center">
        <%
            if (ViewData.GetBool("isCategory", true))
            {
                Response.Write(SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ListClubsByCategory", "ChannelClub", new RouteValueDictionary { { "sortBy", sortBy }, { "categoryID", Html.GetParameterFromRouteDateOrQueryString("categoryID", 0) }, { "pageIndex", "{0}" } })));
            }
            else
            {
                Response.Write(SPBHtmlHelper.Instance().PagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("ListClubsByArea", "ChannelClub", new RouteValueDictionary { { "sortBy", sortBy }, { "areaCode", Html.GetParameterFromRouteDateOrQueryString("areaCode", 0) }, { "pageIndex", "{0}" } })));
            } %>
    
<div class="tn-page-results tn-text-note">
        <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
</div>
<%}%>
