﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<Club>>" %>
<%  int applicationId = ApplicationIDs.Instance().Club();
    if (ViewData.Model != null)
    {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-hot-clubs-main">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=ViewData.GetString("moduleTitle",GetResourceString("Title_ClubModel",applicationId)) %></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list tn-helper-clearfix">
      <% foreach (var club in ViewData.Model)
               {%>
      <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar"> <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank"> <%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID, ClubLogoSizeTypes.Small, new RouteValueDictionary { { "alt", club.ClubName } })%> </a> </div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank" title="<%=StringUtils.Trim(club.ClubName,200) %>"> <%=StringUtils.Trim(club.ClubName,15) %></a></h5>
          </div>
          <div class="tn-list-item-row">
            <p> <%=HtmlUtils.TrimHtml(club.Brief,20) %></p>
            <p> <em class="tn-text-note"> <%=GetResourceString("Label_ClubMemberCount",applicationId)%><%=GetResourceString("Common_Colon") %><%=club.MemberCount %></em> <em class="tn-text-note"> <%=GetResourceString("Label_PeopleHit", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.HitTimes %></em></p>
          </div>
        </div>
      </li>
      <%} %>
    </ul>
    <p class="tn-more">
      <% if (ViewData.Model.Count > 0)
               {%>
      <a href="<%=SPBUrlHelper.Action("ClubRanks", "ChannelClub", new RouteValueDictionary { { "sortBy", ViewData.Get<ClubsSortBy>("sortBy", ClubsSortBy.CreateDate) } })%>"> <%=GetResourceString("Action_More")%></a>
      <%
                }%>
    </p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
