﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<Club>>" %>
<%  int applicationId = ApplicationIDs.Instance().Club();
    if (ViewData.Model != null && Model.Count > 0)
    {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-clubs-list-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_SameCityClub", ApplicationIDs.Instance().Club())%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list">
      <% if (Model.Count > 0)
               {
                   foreach (Club club in ViewData.Model)
                   {%>
      <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar"> <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank"> <%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID, ClubLogoSizeTypes.Small, new RouteValueDictionary { { "alt", club.ClubName } })%> </a> </div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank"> <%=StringUtils.Trim(club.ClubName, 15)%></a></h5>
          </div>
          <div class="tn-list-item-row"> <em class="tn-text-note"> <%=GetResourceString("Label_ClubMemberCount", applicationId)%><%=GetResourceString("Common_Colon")%><%=club.MemberCount%></em> <em class="tn-text-note"> <%=GetResourceString("Label_PeopleHit", applicationId)%><%=GetResourceString("Common_Colon")%><%=club.HitTimes%></em> </div>
        </div>
      </li>
      <%}
               }
               else { Response.Write(GetResourceString("Message_noClub",applicationId)); }%>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("Search", "ChannelClub", new RouteValueDictionary { { "areaCode", ViewData.GetInt("areaCode", 0) } })%>"> <%=GetResourceString("Action_More")%></a> </p>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
