﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<Club>>" %>
<ul class="tn-list tn-helper-reset">
    <% if (ViewData.Model != null && ViewData.Model.Count > 0)
       { %>
    <% foreach (Club club in ViewData.Model)
       {%>
    <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
               <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                <%=SPBHtmlHelper.Instance().ShowClubLogo(club.ClubID, ClubLogoSizeTypes.Small,new RouteValueDictionary {{"alt",club.ClubName}})%><span
                    class="tn-round-corner"></span></a>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <a href="<%=SiteUrls.Instance().ClubDomainHome(club.DomainName) %>" target="_blank">
                        <%=club.ClubName%></a></h5>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <%=HtmlUtils.TrimHtml(club.Brief,20)%></p>
            </div>
        </div>
    </li>
    <%} %>
    <%} %>
</ul>
