﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<RecommendedItem>>" %>
<% Club recommendClub = null;
   int applicationId = ApplicationIDs.Instance().Club();
   bool hasBorder = Html.GetParameterFromRouteDateOrQueryString<bool>("hasBorder");
%>
<% 
    if (Model != null && Model.Records.Count > 0)
    {
        if (hasBorder)
        {%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-clubs-list-block">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <%
                if (ViewData["recommendationType"] != null)
                {
                    RecommendationType recommendationType = ViewData.Get<RecommendationType>("recommendationType");
                    Response.Write(recommendationType.GetMultilingualRecommendationTypeName(CurrentUserLanguage));
                }
            %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <%} %>
    <ul class="tn-list">
      <%
                foreach (RecommendedItem item in Model.Records)
                {
                    recommendClub = Clubs.GetClub(item.ItemID, false);
                    if (recommendClub != null)
                    {%>
      <li class="tn-list-item tn-helper-clearfix">
        <div class="tn-list-item-area-left">
          <div class="tn-avatar"> <a href="<%=SiteUrls.Instance().ClubDomainHome(recommendClub.DomainName) %>" target="_blank"> <%=SPBHtmlHelper.Instance().ShowClubLogo(recommendClub.ClubID, ClubLogoSizeTypes.Small, new RouteValueDictionary { { "alt", recommendClub.ClubName } })%><span
                                class="tn-round-corner"></span></a> </div>
        </div>
        <div class="tn-list-item-area-main">
          <div class="tn-list-item-row tn-list-item-heading">
            <h5 class="tn-helper-reset"> <a href="<%=SiteUrls.Instance().ClubDomainHome(recommendClub.DomainName) %>" target="_blank"> <%=string.IsNullOrEmpty(item.ItemName)?recommendClub.ClubName:item.ItemName%></a></h5>
          </div>
          <div class="tn-list-item-row"> <em class="tn-text-note"> <%=GetResourceString("Label_ClubMemberCount",applicationId)%><%=GetResourceString("Common_Colon") %><%=recommendClub.MemberCount.ToString()%></em> <em class="tn-text-note"> <%=GetResourceString("Label_PeopleHit", applicationId)%><%=GetResourceString("Common_Colon") %><%=recommendClub.HitTimes.ToString()%></em> </div>
        </div>
      </li>
      <% }
                }    
            %>
    </ul>
    <%   if (hasBorder)
             {%>
  </div>
</div>
<div class="tn-blank10"> </div>
<%} %>
<%}%>
