﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="tagIt" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<% 
    int applicationID = ViewData.GetInt("applicationID", -1);
    int clubApplicationId = ApplicationIDs.Instance().Club();
    string contentSubject = ViewData.GetString("contentSubject", string.Empty);
    string contentBody = ViewData.GetString("contentBody", string.Empty);

    string contentUrl = ViewData.GetString("contentUrl", string.Empty);
    string contentImgUrl = ViewData.GetString("contentImgUrl", string.Empty);

    string contentAuthor = ViewData.GetString("contentAuthor", string.Empty);
    int contentUserID = ViewData.GetInt("contentUserID", 0);

    string shareAuthor = ViewData.GetString("shareAuthor", string.Empty);
    int shareAuthorID = ViewData.GetInt("shareAuthorID", 0);

    string getSuggestClubsUrl = SPBUrlHelper.Action("GetSuggestClubsJosn", "ChannelClub", new RouteValueDictionary { { "contentUrl", contentUrl } });
    string GetMyAllClubsUrl = SPBUrlHelper.Action("GetMyClubs", "ChannelClub");

    string controlName = "shareToMyClubsControl";
    PagingDataSet<Club> currentUserClubs = ViewData.Get<PagingDataSet<Club>>("currentUserClubs", null);
    List<int> commendClubIDs = ViewData.Get<List<int>>("commendClubIDs", null);
    bool error = false;
%>
<%
    if (TempData["StatusMessageData"] != null)
    {
        StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData.MessageType, messageData.MessageContent, new RouteValueDictionary { { "style", "width: 500px; " } }));
        if (messageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('if($.nyroModalRemove)$.nyroModalRemove();else self.close();',2000)</script>"));
        }
        else
        {
            error = true;
        }
        TempData["StatusMessageData"] = null;
    }
    if (!error)
    {%>

<form method="post" class="nyroModal" id="shareToMyClubsForm" action="<%=SPBUrlHelper.Action("ShareToMyClubsAction","ChannelClub",new RouteValueDictionary{{"applicationID",applicationID},{"contentUrl",WebUtils.UrlEncode(contentUrl)},{"shareAuthorID",shareAuthorID},{"authorUserID",contentUserID}}) %>">
  <div class="tn-form tn-label-right">
    <div class="tn-form-row tn-form-expanded tn-helper-clearfix spb-select-club">
      <label class="tn-form-label"> <%=GetResourceString("Label_ChooseMyClub", clubApplicationId)%><%=GetResourceString("Common_Colon") %></label>
      <div class="tn-expand-control">
        <input id="<%=controlName %>" name="<%=controlName %>" type="text" />
      </div>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <textarea name="contentBody" id="contentBody" class="tn-textarea tn-input-long tn-border-gray"
            rows="5" cols="20">
      <%=!string.IsNullOrEmpty(contentBody) ? contentBody.Trim() : string.Empty %>
      </textarea><span style="display:none"></span>
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_ShareMyContent", clubApplicationId)%><%=GetResourceString("Common_Colon") %></label>
      <h4> <%=HtmlUtils.TrimHtml(contentSubject,30) %></h4>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <div class="tn-text-note"> <%=string.Format(GetResourceString("Label_Pattern_ComeForm",clubApplicationId ), contentAuthor)%></div>
    </div>
    <input type="hidden" id="contentSubject" name="contentSubject" value="<%=contentSubject %>" />
    <input type="hidden" id="contentAuthor" name="contentAuthor" value="<%=contentAuthor %>" />
    <input type="hidden" id="contentImgUrl" name="contentImgUrl" value="<%=contentImgUrl %>" />
    <input type="hidden" id="shareAuthor" name="shareAuthor" value="<%=shareAuthor %>" />
    <input type="hidden" id="shareAuthorID" name="shareAuthorID" value="<%=shareAuthorID %>" />
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("ShareToClub", GetResourceString("Button_Share", clubApplicationId),ButtonSizes.Large,null,null)%> <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Large, new RouteValueDictionary { { "onclick", "$.nyroModalRemove()" } })%> </div>
  </div>
  <script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#ShareToClub").click(function() {
            if (!$("#shareToMyClubsForm").valid()) {
                return false;
            }
        });
        $(".nyroModal").nyroModal();
        $("#<%=controlName %>").autoSuggest("<%=getSuggestClubsUrl  %>", {
            asHtmlID: "<%=controlName %>",
            selectedValuesProp: "clubID",
            allSelectData: "<%=GetMyAllClubsUrl %>"
        });
        
            $("#shareToMyClubsForm").validate({
            rules: {
                contentBody: "required"
            },
            messages: {
                contentBody: "不可为空！"
            }
        });
    }); 
</script>
</form>
<%} %>