﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<Dictionary<string, string>>" %>
<% 
    int areaLevel = Html.GetParameterFromRouteDateOrQueryString("areaLevel", 1);
    string controlName = Html.GetParameterFromRouteDateOrQueryString("controlName");
    if (string.IsNullOrEmpty(controlName))
        controlName = "areaCode";
    string cssClass = Html.GetParameterFromRouteDateOrQueryString("cssClass");
    if (string.IsNullOrEmpty(cssClass))
        cssClass = "dropDownList";
    string selectedAreaCode = Html.GetParameterFromRouteDateOrQueryString("selectedAreaCode");
    int rootAreaDepth = ViewData.GetInt("rootAreaDepth", 0);
    Dictionary<string, string> rootAreas = ViewData.Get<Dictionary<string, string>>("rootAreas", null);
    Stack<KeyValuePair<string, Dictionary<string, string>>> stack = null;
    Area selectedArea = null;
    if (!string.IsNullOrEmpty(selectedAreaCode))
    {
        stack = ViewData.Get<Stack<KeyValuePair<string, Dictionary<string, string>>>>("stack", null);
        selectedArea = ViewData.Get<Area>("selectedArea", null);
    }
%>
<span>
    <%
        if (string.IsNullOrEmpty(selectedAreaCode))
        {
            if (rootAreas != null)
                Response.Write(SPBHtmlHelper.Instance().ShowDropDownList<string, string>(controlName, rootAreas, new RouteValueDictionary { { "id", string.Format("{0}_{1}", controlName, rootAreaDepth) }, { "class", cssClass } }, string.Empty, string.Empty, GetResourceString("Common_PleaseChoose")));
        }
        else if (stack != null && selectedArea != null)
        {
            int currentDepth = rootAreaDepth;
            while (stack.Count > 0)
            {
                KeyValuePair<string, Dictionary<string, string>> pair = stack.Pop();
                Response.Write(SPBHtmlHelper.Instance().ShowDropDownList<string, string>(controlName, pair.Value, new RouteValueDictionary { { "id", string.Format("{0}_{1}", controlName, currentDepth) }, { "class", cssClass } }, pair.Key, string.Empty, GetResourceString("Common_PleaseChoose")));
                currentDepth++;
            }
        }
    %>
</span>

<script type="text/javascript" rel="forceLoad">
     $(document).ready(function() {
                $("select[id^='<%=controlName %>_']").change(<%=controlName %>DropDownListChange).eq(0).attr("name","<%=controlName %>");
                <% if(selectedArea!=null){ %>
                $("#<%=controlName %>_<%=selectedArea.Depth %>").change();
                <%}%>
      });
      function <%=controlName %>DropDownListChange(){
          var index=eval(this.id.substr("<%=controlName %>".length+1));
          var $currentDropDownList=$(this);
          //如果选中有效值，则将当前下拉列表设置为表单项；否则将前一个下拉列表设置为表单项
          if($currentDropDownList.val()&&$currentDropDownList.val().length>0)
          {
              $currentDropDownList.attr("name","<%=controlName %>").siblings().removeAttr("name");
              if(index<<%=areaLevel %>)
              {
                  $.getJSON('<%=SPBUrlHelper.Action("GetChildAreas","Channel") %>', { areaCode: $currentDropDownList.val() }, function(data) {  
                      $currentDropDownList.nextAll().remove().end()
                      .after("\n<select id=\"<%=controlName %>_"+eval(parseInt(index)+1)+"\" class=\"<%=cssClass %>\"><option value=\"\">"+"<%=GetResourceString("Common_PleaseChoose") %>"+"</option></select>");
                      $(data).each(function(){
                      $("#<%=controlName %>_"+eval(parseInt(index)+1))
                      .append("<option value=\""+this.id+"\">"+this.name +"</option>");
                      });
                      $("#<%=controlName %>_"+eval(parseInt(index)+1)).change(<%=controlName %>DropDownListChange);
                  });
              }
          }
           else if(index>0)
           {
                $("#<%=controlName %>_"+eval(parseInt(index)-1)).attr("name","<%=controlName %>").siblings().removeAttr("name");
                $currentDropDownList.nextAll().remove();
          }

      }
</script>

