﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" Src="~/Utility/jquery/ui.datepicker.min-1.8.12.js" SetExpireDays="30" />
<% if (CurrentUserLanguage.ToLower() == "zh-cn")
   { %>
<spb:Script runat="server" Src="~/Utility/jquery/i18n/ui.datepicker-zh-CN.js" SetExpireDays="30" />
<%} %>
<% DateTime? selectedDateTime = (DateTime?)ViewData["DateTime"];
   string controlName = ViewData.GetString("ControlName", "datetime");
   string cssClass = ViewData.GetString("CssClass", "tn-textbox tn-input-medium tn-border-gray");
   bool showTime = ViewData.GetBool("ShowTime", true);
   string strSelectedDateTime = string.Empty;
   if (selectedDateTime.HasValue)
       strSelectedDateTime = selectedDateTime.Value.ToString("yyyy-MM-dd"); %>
<input id="<%=controlName %>ofdate" name="<%=controlName %>ofdate" type="text" value="<%= strSelectedDateTime %>"
    class="<%=cssClass %>" />
<% if (showTime)
   { %>
<select id="<%=controlName %>oftime" class="tn-dropdownlist" name="<%=controlName %>time">
    <%TimeSpan startTimeSpan = new TimeSpan(0, 0, 0);
      TimeSpan endTimeSpan = new TimeSpan(24, 0, 0);
      TimeSpan intervalTimeSpan = new TimeSpan(0, 30, 0);
      for (TimeSpan ts = startTimeSpan; ts < endTimeSpan; ts = ts + intervalTimeSpan)
      { %>
    <option>
        <%=string.Format("{0:00}:{1:00}", ts.Hours, ts.Minutes)%></option>
    <%}%>
</select>
<%} %>
<input type="hidden" id="<%=controlName %>" name="<%=controlName %>" value="<%=strSelectedDateTime %>" />
<%  string timeSelectText = string.Empty;
    if (selectedDateTime.HasValue)
    {
        TimeSpan ts1 = selectedDateTime.Value.TimeOfDay;
        TimeSpan ts2 = new TimeSpan(ts1.Hours, ts1.Minutes / 30 * 30, 0);
        timeSelectText = string.Format("{0:00}:{1:00}", ts2.Hours, ts2.Minutes);
    }
    int minYear = ViewData.GetInt("minYear", 2000);
    int maxYear = ViewData.GetInt("maxYear", 2020);
%>

<script type="text/javascript">
    $(document).ready(function() {
    $('#<%=controlName %>ofdate').datepicker({ 
    <%if (selectedDateTime.HasValue)
     { %>
    defaultDate: new Date(<%=selectedDateTime.Value.Year %>,<%=selectedDateTime.Value.Month %>-1,<%=selectedDateTime.Value.Day %>), 
    <%} %>
    changeMonth: true,
    changeYear: true,
    yearRange: '<%=minYear %>:<%=maxYear %>',
    dateFormat: $.datepicker.W3C });
    <%if (selectedDateTime.HasValue)
     { %>
        $("#<%=controlName %>oftime option:contains('<%=timeSelectText %>')").attr("selected", "selected");
        <%} %>
        $("#<%=controlName %>ofdate").change(function() {
            var datetime = $("#<%=controlName %>ofdate").val() <% if(showTime){ %>  + " " + $("#<%=controlName %>oftime").val() <%} %>;
            $("#<%=controlName %>").attr("value",datetime);
        });
        <% if (showTime)
        { %>
            $("#<%=controlName %>oftime").change(function() {
                var datetime = $("#<%=controlName %>ofdate").val() + " " + $("#<%=controlName %>oftime").val();                
                $("#<%=controlName %>").attr("value",datetime);
            });
            $("#<%=controlName %>oftime").change();
        <%} %>
    });
    
</script>

