﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<UserIdentifier>>" %>
<spb:Script runat="server" ID="autoSuggest" Src="~/Utility/jquery/plugin/jquery.autoSuggest-1.4.js"
    SetExpireDays="30" />
<% string controlName = Html.GetParameterFromRouteDateOrQueryString("controlName");
   if (string.IsNullOrEmpty(controlName))
       controlName = "friendSelector";
   int selectionLimit = Html.GetParameterFromRouteDateOrQueryString<int>("selectionLimit");
   string selectionAdded = Html.GetParameterFromRouteDateOrQueryString("selectionAdded");
   if (selectionLimit == default(int))
       selectionLimit = 30;
   string getAllFriendsUrl = SPBUrlHelper.Action("GetMyFriends", "Channel");
   string searchFriendsUrl = SPBUrlHelper.Action("SearchUsers", "Channel");
   string getFriendCategoriesUrl = SPBUrlHelper.Action("GetMyFriendCategories", "Channel");
   string selectedUsersValue = "{}";
   string inputClass = Html.GetParameterFromRouteDateOrQueryString("inputClass");
   if (string.IsNullOrEmpty(inputClass))
       inputClass = "tn-input-long";

   System.Web.Script.Serialization.JavaScriptSerializer serializer = new System.Web.Script.Serialization.JavaScriptSerializer();
   if (Model != null && Model.Count > 0)
   {
       selectedUsersValue = serializer.Serialize(Model.Select(n => new
       {
           userID = n.UserID,
           displayName = n.DisplayName,
           commonName = n.CommonName,
           nickName = n.NickName,
           userAvatarUrl = SiteUrls.Instance().UserAvatarUrl(n.UserID, AvatarSizeTypes.Small)
       }));
   }   
%>
<div class="tn-expand-control">
    <input id="<%=controlName %>" type="text" />
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("#<%=controlName %>").autoSuggest("<%=searchFriendsUrl %>",
        {   asHtmlID: "<%=controlName %>",
            startText: "<%=GetResourceString("Title_SelectFriend",ApplicationIDs.Instance().Friend()) %>",
            defaultCategory:"<%=GetResourceString("Title_AllFriends",ApplicationIDs.Instance().Friend()) %>",
            buttonText: "<%=GetResourceString("Button_OK") %>",
            limitTextPattern: "<%=GetResourceString("Title_Pattern_MaxFriendCount",ApplicationIDs.Instance().Friend()) %>",
            remainTextPattern: "<%=GetResourceString("Title_Pattern_RemainFriendCount",ApplicationIDs.Instance().Friend()) %>",
            selectionLimit: <%=selectionLimit %>,
            preFill: <%=selectedUsersValue %>,
            allSelectData: "<%=getAllFriendsUrl %>",
            categoryData: "<%=getFriendCategoriesUrl %>",            
            selectedItemProp: "displayName",
            selectedValuesProp: "userID",
            searchObjProps: "displayName,commonName,nickName,noteName",
            formatList: function(data, elem) {
            var new_elem = elem.html("<a href=\"javascript:;\"><img src=\"" + data.userAvatarUrl + "\" width=\"22px\">" + data.displayName + "</a>");
                return new_elem;
            }
            <%if(!string.IsNullOrEmpty(selectionAdded)){%>
            ,
            selectionAdded:<%=selectionAdded %>
            <%} %>
        });
    });
   
</script>

