﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<Rating>>" %>
<%if (Model != null && Model.Count > 0)
  { %>
<div class="tn-visitors tn-collapsible tn-collapsible-opened">
    <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
        <h4 class="tn-helper-reset">
            <%=GetResourceString("Description_GradeDetail", ApplicationIDs.Instance().Blog())%></h4>
    </div>
    <div class="tn-collapsible-content">
        <ul class="tn-avatar-list tn-helper-reset">
            <%  
                string[] starTitles = { GetResourceString("Description_VeryPoor"),
             GetResourceString("Description_Poor"),
             GetResourceString("Description_General"),
             GetResourceString("Description_Good"),
             GetResourceString("Description_VeryGood"),
               };
                foreach (var rating in Model)
                { %>
            <li class="tn-avatar-item">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(rating.UserID, true, HyperLinkTarget._self, AvatarSizeTypes.Small)%></div>
                <a class="tn-text-heading" href="<%=SiteUrls.Instance().UserDomainHome(rating.UserID) %>">
                    <%=rating.Author%></a><span class="tn-text-note"><%=starTitles[rating.Rate - 1]%></span></li>
            <%} %>
        </ul>
    </div>
</div>
<%}%>