﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<SiteCategory>>" %>
<% if (ViewData.Model != null && ViewData.Model.Count > 0)
   {
       List<SiteCategory> siteCategoryList = ViewData.Model;
       string controlName = ViewData["controlName"] as string;
       string cssClass = (string)ViewData["cssClass"];
       SiteCategory currentSiteCategory = ViewData.Get<SiteCategory>("currentSiteCategory", null);%>
<select name="<%=controlName %>" id="<%=controlName %>" class="<%=cssClass %>">
    <option value="">--<%=GetResourceString("Common_PleaseChoose") %>
        -- </option>
    <% foreach (SiteCategory siteCategory in siteCategoryList)
       {
           string blankSpace = string.Empty; %>
    <option value="<%=siteCategory.CategoryID %>">
        <% 
            for (int i = 0; i < siteCategory.Depth; i++)
            {
                blankSpace = blankSpace + "　";
            }
            Response.Write(blankSpace);
        %><%=siteCategory.GetMultilingualCategoryName(CurrentUserLanguage)%></option>
    <%} %>
</select>
<% if (currentSiteCategory != null)
   {%>

<script type="text/javascript">
    $(document).ready(function() {
        $("#<%=controlName %>").val("<%=currentSiteCategory.CategoryID %>");
    });

</script>

<%}
   }
   else
   {%>
<span class="annotation"><%=GetResourceString("Description_None") %></span>
<%} %>