﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int presentAreaID = ViewData.GetInt("presentAreaID");
    int ownerID = ViewData.GetInt("ownerID");
    string pageCode = ViewData.GetString("pageCode");

    IList<ThemeAppearance> themeAppearances = ViewData.Get<IList<ThemeAppearance>>("themeAppearances");
    KeyValuePair<string, string> selectedThemeAppearance = ViewData.Get<KeyValuePair<string, string>>("selectedThemeAppearance");

    string themeLocation = ViewData.Get<string>("themeLocation");
    string exitUrl = ViewData.GetString("exitUrl");

    IList<Widget> initialWidgets = null;
    Dictionary<string, int> usedWidgetIDsOfPage = null;
    IList<string> layoutModes = null;
    string currentLayoutMode = null;
    PresentArea presentArea = ViewData.Get<PresentArea>("presentArea", null);

    Theme currentTheme = Themes.GetTheme(presentAreaID, selectedThemeAppearance.Value, false, true);
    if (currentTheme.EnableChangeLayout)
    {
        initialWidgets = ViewData.Get<IList<Widget>>("initialWidgets");
        usedWidgetIDsOfPage = ViewData.Get<Dictionary<string, int>>("usedWidgetIDsOfPage");

        layoutModes = ViewData.Get<IList<string>>("layoutModes");
        currentLayoutMode = ViewData.Get<string>("currentLayoutMode");
    }
    RouteValueDictionary dictionary = new RouteValueDictionary() { { "presentAreaID", presentAreaID } };
    if (presentAreaID == PresentAreaIDs.Instance().UserDomain() || presentAreaID == PresentAreaIDs.Instance().MicroBlogDomain())
        dictionary.Add("userDomainName",WebUtils.UrlEncode(Html.GetParameterFromRouteDateOrQueryString("userDomainName")));
    else if (presentAreaID == PresentAreaIDs.Instance().ClubDomain())
        dictionary.Add("clubDomainName", WebUtils.UrlEncode( Html.GetParameterFromRouteDateOrQueryString("clubDomainName"))); 
    
%>
<div class="spb-custom-control">
    <div class="spb-custom-bar tn-widget-content tn-bg-light tn-border-bottom">
    </div>
    <div class="spb-custom-panel tn-widget-content tn-bg-light tn-border-rbl tn-corner-bottom">
        <div class="tn-text-heading">
            <h3 class="tn-helper-reset">
                <%=GetResourceString("Title_Caption") %></h3>
        </div>
        <div id="themeSettingsContainer" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
            <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
                <li class="ui-state-default ui-corner-top"><a href="#themeAppearanceList"><span>
                    <%=GetResourceString("Title_ThemeAppearance")%></span> </a></li>
                <% if (currentTheme.EnableChangeLayout)
                   { %>
                <li class="ui-state-default ui-corner-top"><a href="#layoutModeList"><span>
                    <%=GetResourceString("Title_LayoutMode")%></span> </a></li>
                <li class="ui-state-default ui-corner-top"><a href="#widgetList"><span>
                    <%=GetResourceString("Title_Widget")%></span></a> </li>
                <% } %>
            </ul>
            <div id="themeAppearanceList" class="ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide">
                <div class="spb-skin-box">
                    <div class="spb-skin-box-wrapper tn-helper-clearfix">
                        <%
                            if (presentArea != null)
                            {
                                foreach (var themeAppearance in themeAppearances)
                                {
                                    if (!presentArea.EnableThemes && !presentArea.DefaultTheme.Equals(themeAppearance.Theme, StringComparison.CurrentCultureIgnoreCase))
                                        continue;

                                    if (themeAppearance.Theme.Equals(selectedThemeAppearance.Value, StringComparison.InvariantCultureIgnoreCase) && themeAppearance.DirectoryName.Equals(selectedThemeAppearance.Key, StringComparison.InvariantCultureIgnoreCase))
                                    {
                                        Response.Write("<div class=\"spb-skin-item\"><a href=\"javascript:;\"  class=\"tn-img-sprite tn-text-note tn-selected\" onclick=\"return false;\">");
                                        Response.Write(string.Format("<img src=\"{0}\" /><span class=\"name\">{1}</span></a></div>", WebUtils.ResolveUrl(themeLocation + themeAppearance.PreviewImageWithPath), themeAppearance.Title));

                                    }
                                    else
                                    {
                                        Response.Write("<div class=\"spb-skin-item\">");
                                        Response.Write(string.Format("<a href=\"javascript:;\"  class=\"tn-img-sprite \" onclick=\"$.post('{0}',{{ 'ownerID':{1}, 'selectedTheme':'{2}','selectedAppearance':'{3}'}}, function(){{refresh();}})\" >", SPBUrlHelper.Action("Control_UpdateThemeAppearance", "Channel", dictionary), ownerID, themeAppearance.Theme, themeAppearance.DirectoryName));

                                        Response.Write(string.Format("<img src=\"{0}\" /><span class=\"name\">{1}</span></a></div>", WebUtils.ResolveUrl(themeLocation + themeAppearance.PreviewImageWithPath), themeAppearance.Title));
                                    }
                                }
                            }    
                        %>
                    </div>
                </div>
            </div>
            <% if (currentTheme.EnableChangeLayout)
               { %>
            <div id="layoutModeList" class="ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide">
                <div class="spb-layout-set tn-helper-clearfix">
                    <%
                   foreach (var layoutMode in layoutModes)
                   {
                       if (layoutMode == currentLayoutMode)
                           Response.Write("<div class=\"spb-layout-icon\"><a class=\"tn-img-sprite tn-text-note tn-selected\" href=\"javascript:;\" onclick=\"return false;\" >");
                       else
                           Response.Write(string.Format("<div class=\"spb-layout-icon\"><a  class=\"tn-img-sprite\" href=\"javascript:;\" onclick=\"$.post('{0}',{{ 'ownerID':{1}, 'layoutMode':'{2}'}}, function(){{refresh()}})\" >", SPBUrlHelper.Action("Control_UpdatePageLayout", "Channel", new RouteValueDictionary() { { "presentAreaID", presentAreaID }, { "pageCode", pageCode }, { "theme", selectedThemeAppearance.Value } }),
                           ownerID, layoutMode));

                       StringBuilder layoutModeString = new StringBuilder();
                       for (int i = 0; i < layoutMode.Length; i++)
                       {
                           layoutModeString.Append(layoutMode[i] + ":");
                       }
                       if (layoutModeString.Length > 0)
                           layoutModeString.Remove(layoutModeString.Length - 1, 1);

                       string currentLayoutModes = string.Empty;
                       foreach (char s in layoutMode)
                       {
                           currentLayoutModes += ("-" + s);
                       }
                       Response.Write(string.Format("<span class=\"tn-img-sprite spb-layout-icon{0}\"></span><b>{1}</b></a></div>", currentLayoutModes, layoutModeString.ToString()));
                   }
                    %>
                </div>
            </div>
            <div id="widgetList" class="ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide">
                <div class="spb-widget-select tn-helper-clearfix">
                    <div class="spb-widget-system">
                        <%
                   foreach (var widget in initialWidgets)
                   {
                       if (!widget.IsRepeatableInPage)
                       {
                           Response.Write("<div class=\"spb-widget-block tn-img-sprite\">");
                           if (usedWidgetIDsOfPage.ContainsKey(widget.WidgetID))
                               Response.Write(string.Format("<input type=\"checkbox\" id=\"widget_{0}\" class=\"tn-checkbox\" checked=\"checked\" onclick=\"$.post('{1}',null, function(){{refresh()}})\" />", widget.WidgetID, SPBUrlHelper.Action("DeleteWidgetInstance", "Channel", new RouteValueDictionary() { { "instanceID", usedWidgetIDsOfPage[widget.WidgetID] } })));
                           else
                               Response.Write(string.Format("<input type=\"checkbox\" id=\"widget_{0}\" class=\"tn-checkbox\" onclick=\"$.post('{1}',null, function(){{refresh()}})\" />", widget.WidgetID, SPBUrlHelper.Action("CreateWidgetInstance", "Channel", new RouteValueDictionary() { { "presentAreaID", presentAreaID }, { "ownerID", ownerID }, { "widgetID", widget.WidgetID }, { "theme", selectedThemeAppearance.Value }, { "pageCode", pageCode } })));

                           Response.Write(string.Format("<label for=\"checkbox_{0}\">{1}</label>", widget.WidgetID, widget.ProcessResourceToken(widget.WidgetName, CurrentUserLanguage)));

                           Response.Write("</div>");
                       }
                   }                
                        %>
                    </div>
                    <div class="spb-widget-custom">
                        <%
                   foreach (var widget in initialWidgets)
                   {
                       if (widget.IsRepeatableInPage)
                       {
                           Response.Write("<div class=\"spb-widget-block tn-img-sprite\"><span>");
                           Response.Write(string.Format("<a  href=\"javascript:;\" onclick=\"$.post('{1}',null, function(){{refresh()}})\" >{2}</a>", widget.WidgetID, SPBUrlHelper.Action("CreateWidgetInstance", "Channel", new RouteValueDictionary() { { "presentAreaID", presentAreaID }, { "ownerID", ownerID }, { "widgetID", widget.WidgetID }, { "theme", selectedThemeAppearance.Value }, { "pageCode", pageCode } }), widget.ProcessResourceToken(widget.WidgetName, CurrentUserLanguage)));
                           Response.Write("</span></div>");
                       }
                   }                
                        %>
                    </div>
                </div>
            </div>
            <% } %>
        </div>
        <div class="tn-form-row-button">
            <label class="tn-form-label">
            </label>
            <%=SPBHtmlHelper.Instance().LinkButton("save", "保存", exitUrl, ButtonSizes.Default, HighlightStyles.Primary)%>
            <%if (currentTheme.EnableChangeLayout)
                  Response.Write(SPBHtmlHelper.Instance().LinkButton("RestoreDefault", GetResourceString("Action_RestoreDefaultSettings"), ButtonSizes.Default, HighlightStyles.Primary, new RouteValueDictionary { { "onclick", "RestoreDefaultSettings()" } }, null));%>
            <%//=SPBHtmlHelper.Instance().CancelButton(exitUrl)%>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        var selectValue = 1;
        var cookieKey = "ThemeSettingSubMenu_<%=pageCode %>_<%=ownerID %>";
        if (getCookie(cookieKey) != null)
            selectValue = parseInt(getCookie(cookieKey));
        $("#themeSettingsContainer").tabs({
            selected: selectValue,
            select: function (event, ui) {
                setCookie(cookieKey, ui.index);
            }
        });
    });
    function RestoreDefaultSettings() {

        $.getJSON('<%=SPBUrlHelper.Action("RestoreDefaultSettings","Channel",new RouteValueDictionary{{"presentAreaID",presentAreaID},{"ownerID",ownerID},{"pageCode",pageCode},{"theme",currentTheme.DirectoryName}}) %>', function (data) {
            if (data.isSuccess)
                refresh();
            else
                alert(data.message);
        }); return false;
    }
</script>
