﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ConvertibleGiftExchangeApply>" %>
<%     int userApplicationID = ApplicationIDs.Instance().User();
       if (ViewData["StatusMessageContent"] != null)
       {
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Error, ViewData.GetString("StatusMessageContent"), 3000,false));
           Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',3000)</script>"));
       }
       else
       { %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
        //StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);

        //关闭模式窗口
        if (messageType == StatusMessageType.Success)
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        TempData["StatusMessageType"] = null;
    }

    ConvertibleGift gift = ViewData.Get<ConvertibleGift>("gift");

    int myCreditPoints =CurrentUser!=null? CurrentUser.TradePoints:0;

    ConvertibleGiftExchangeApply giftApply = ViewData.Model as ConvertibleGiftExchangeApply; ;
%>
<%string action = string.Empty;
  if (giftApply != null)
      action = SPBUrlHelper.Action("UpdateGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "applyID", giftApply.ApplyID } });
  else
      action = SPBUrlHelper.Action("CreateGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", gift.GiftID } });
%>
<form action="<%=action%>" method="post" id="editorForm" class="tn-helper-reset nyroModal">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <%=GetResourceString("Label_GiftExchange",userApplicationID) %>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_GiftName",userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <%=gift.Subject %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_BuyingNumber", userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="TotalCount"
            value="<%if (giftApply != null) Response.Write(giftApply.TotalCount); %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_ThePurchasePrice", userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <%=gift.Price %>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_MyCurrentPoints", userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <%=myCreditPoints%>
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_ConsigneeAddress", userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray" name="consigneeAddress"
            value="<% if (giftApply != null) Response.Write(giftApply.ConsigneeAddress); %>" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_ConsigneeName", userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <input type="text" maxlength="100" class="tn-textbox tn-input-medium tn-border-gray"
            value="<% if (giftApply != null) Response.Write(giftApply.Consignee); %>" name="consignee" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_ConsigneePhone", userApplicationID)%><%=GetResourceString("Common_Colon")%>
        </label>
        <input type="text" class="tn-textbox tn-input-medium tn-border-gray"
            name="ConsigneePhone" value="<% if (giftApply != null) Response.Write(giftApply.ConsigneePhone); %>" />
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("editorFormsaveButton", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%>
        <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "onclick" ,"$.nyroModalRemove();"} })%>
    </div>
</div>
</form>
<%} %>

<script type="text/javascript">

    $(document).ready(function() {
        $("#editorForm").validate({
            rules: {
                TotalCount: { required: true, digits: true },
                consigneeAddress: { required: true },
                consignee: { required: true,maxBlength:100 },
                ConsigneePhone: { required: true, minlength: 4, maxlength: 20 }
            },
            messages: {
                TotalCount: { required: "<%=GetResourceString("Description_Required")%>", digits: "<%=GetResourceString("Validate_Displayorder_Digits",userApplicationID)%>" },
                consigneeAddress: { required: "<%=GetResourceString("Description_Required")%>" },
                consignee: { required: "<%=GetResourceString("Description_Required")%>", maxBlength: "<%=string.Format(GetResourceString("Validate_Pattern_Decript_Maxlength", userApplicationID),100)%>" },
                ConsigneePhone: { required: "<%=GetResourceString("Description_Required")%>", minlength: '<%=GetResourceString("Validate_LinkTelMinlength", userApplicationID)%>', maxlength: '<%=GetResourceString("Validate_LinkTelMaxlength", userApplicationID)%>' }
            }
        });

        $("#editorFormsaveButton").click(function() {
            if (!$("#editorForm").valid()) {
                return false;
            }
        });
    }); 
</script>

