﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% List<ConvertibleGift> gifts = ViewData["gifts"] as List<ConvertibleGift>;
   int sortBy = ViewData.GetInt("sortBy", 0);
   int userApplicationID = ApplicationIDs.Instance().User();
%>

<div id="giftSortBy<%=sortBy %>" class="tn-box tn-widget tn-widget-content tn-corner-all spb-gifts-hot">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <%if (sortBy == (int)ConvertibleGiftSortBy.ExchangedCount) Response.Write(GetResourceString("Title_SellingGifts", userApplicationID));
              else if (sortBy == (int)ConvertibleGiftSortBy.DateCreated) Response.Write(GetResourceString("Label_TheLatestShelves", userApplicationID)); %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="spb-gifts-list tn-helper-clearfix">
      <% foreach (ConvertibleGift gift in gifts)
               {%>
      <li class="spb-gift-item"><a class="spb-gift-box tn-border-gray" href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>">
        <%
                    if (gift != null && !string.IsNullOrEmpty(gift.ImageFileName))
                    {
                        Response.Write(string.Format("<img src=\"{0}\" width=\"70\" height=\"70\" /><br/>", SiteUrls.Instance().GiftPhoto(gift)));
                    }
                %>
        </a> <a class="tn-text-heading" href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>"> <%=gift.Subject %> </a><em class="tn-text-note"><%=GetResourceString("Label_NeedPoints",userApplicationID) %><%=GetResourceString("Common_Colon")%><%=gift.Price%></em>
        <div class="spb-gift-action">
          <% if (CurrentUser == null)
                       {%>
          <%=SPBHtmlHelper.Instance().LinkButton(gift.GiftID.ToString(), GetResourceString("Button_WantToCash", userApplicationID), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, null, null)%>
          <%}
                       else
                       {%>
          <%=SPBHtmlHelper.Instance().LinkButton(gift.GiftID.ToString(), GetResourceString("Button_WantToCash", userApplicationID), SPBUrlHelper.Action("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", gift.GiftID } }), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
          <%} %>
        </div>
      </li>
      <%} %>
    </ul>
    <p class="tn-more"><a href="<%=SPBUrlHelper.Action("ListGifts","ChannelConvertibleGift",new RouteValueDictionary{{"sortBy",(ConvertibleGiftSortBy)sortBy}}) %>"> <%=GetResourceString("Title_SeeAll",userApplicationID) %></a></p>
  </div>
</div>
<script type="text/javascript">

    $(document).ready(function() {
        $('a.nyroModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 400
        });
    });

</script>
