﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%List<ConvertibleGiftExchangeRecord> giftExchangeRocord = ViewData.Get<List<ConvertibleGiftExchangeRecord>>("giftExchangeRocord");
  int userApplicationID = ApplicationIDs.Instance().User();
%>

<div id="topGiftExchangeRocord" class="tn-box tn-widget tn-widget-content tn-corner-all spb-exchange-new">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Label_GiftsExchangeRecord", userApplicationID)%></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-list tn-helper-reset">
      <%foreach (ConvertibleGiftExchangeRecord record in giftExchangeRocord)
              {
                  if (record.GiftID > 0)
                  { %>
      <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-row"><a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(record.UserID, UserDomainSpecialAppIDs.Instance().Home()) %>"> <%=string.IsNullOrEmpty(record.UserDisplayName)?SPBHtmlHelper.Instance().UserDisplayName(record.UserID):record.UserDisplayName %></a><%=string.Format(GetResourceString("Label_SpendPointForBuy", userApplicationID), record.Price)%><a href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",record.GiftID}})%>"><%=ConvertibleGifts.GetGift(record.GiftID, false).Subject%></a><%=record.TotalCount%><%=GetResourceString("Label_ge",userApplicationID) %> <em class="tn-text-note tn-date"><%=Formatter.FormatDate(record.DateCreated)%></em></div>
      </li>
      <%}
              }%>
    </ul>
  </div>
</div>
