﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<RecommendedItem>>" %>
<% //IList<ConvertibleGift> commendGiftThreads = ViewData.Model as IList<ConvertibleGift>;
    int userApplicationID = ApplicationIDs.Instance().User();
    ConvertibleGift gift = null;
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-gifts-recommended">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset"> <%=GetResourceString("Title_RecommendGifts",userApplicationID) %></h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="spb-gifts-list tn-helper-clearfix">
      <%foreach (RecommendedItem item in Model)
              {
                  gift = ConvertibleGifts.GetGift(item.ItemID, false);
                  if (gift == null)
                      continue;
            %>
      <li class="spb-gift-item"><a class="spb-gift-box tn-border-gray" href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>">
        <%
                    if (gift != null && !string.IsNullOrEmpty(gift.ImageFileName))
                    {
                        Response.Write(string.Format("<img src=\"{0}\" width=\"70\" height=\"70\" />", SiteUrls.Instance().GiftPhoto(gift)));
                    }
                %>
        </a><a class="tn-text-heading" href="<%=SPBUrlHelper.Action("ShowGift", "ChannelConvertibleGift",new RouteValueDictionary {{"giftID",gift.GiftID}})%>"
                title="<%=gift.Subject %>"> <%=StringUtils.Trim(item.ItemName,15) %></a> <em class="tn-text-note"> <%=GetResourceString("Label_NeedPoints",userApplicationID) %><%=GetResourceString("Common_Colon")%><%=gift.Price%></em>
        <div class="spb-gift-action">
          <% if (CurrentUser == null)
                       {%>
          <%=SPBHtmlHelper.Instance().LinkButton(gift.GiftID.ToString(), GetResourceString("Button_WantToCash", userApplicationID), SiteUrls.Instance().Login(true), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, null, null)%>
          <%}
                       else
                       {%>
          <%=SPBHtmlHelper.Instance().LinkButton(gift.GiftID.ToString(), GetResourceString("Button_WantToCash", userApplicationID), SPBUrlHelper.Action("Control_NewGiftApply", "ChannelConvertibleGift", new RouteValueDictionary { { "giftID", gift.GiftID } }), ButtonSizes.Default, HighlightStyles.Default, null, TextIconLayout.TextOnly, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
          <%} %>
        </div>
      </li>
      <%} %>
    </ul>
  </div>
</div>
<script type="text/javascript">

    $(document).ready(function() {
        $('a.nyroModal').nyroModal({
            resizeable: true,
            width: 300,
            height: 400
        });
    });

</script>
