﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%         ChannelEventSubMenu subMenu = ChannelEventSubMenu.Home;
           if (ViewData["ChannelEventSubMenu"] != null)
               subMenu = (ChannelEventSubMenu)ViewData["ChannelEventSubMenu"];
                 
%>
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    string areaCode = Html.GetParameterFromRouteDateOrQueryString("areaCode");
    int categoryID = Html.GetParameterFromRouteDateOrQueryString<int>("siteCategoryID");
    int eventID = Html.GetParameterFromRouteDateOrQueryString<int>("eventID");%>
<div class="spb-nav2-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav2 tn-helper-reset tn-helper-clearfix sf-menu sf-js-enabled sf-shadow">
            <li <% if (subMenu == ChannelEventSubMenu.Home) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().ChannelEventHome()) %>">
                    <%=GetResourceString("Navigation_EventHome", EventApplicationID)%></a></li>
            <li <% if (subMenu == ChannelEventSubMenu.Search) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelEvent")) %>">
                    <%=GetResourceString("Navigation_EventSearch",EventApplicationID) %></a></li>
                    
                     <li <% if (subMenu == ChannelEventSubMenu.Review) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ListEventsReview","ChannelEvent")) %>">
                    活动回顾</a></li>
            <% if (CurrentUser != null)
               { %>
            <li <% if (subMenu == ChannelEventSubMenu.MyEvents) Response.Write("class=\"spb-nav-item tn-text-note tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a target="_blank" href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("ListMyEvents", "UserDomainEvent", new RouteValueDictionary { { "UserDomainName", CurrentUser.UserName} }))%>">
                    <%=GetResourceString("Navigation_MyEvent",EventApplicationID)%></a></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="spb-header-bottom">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <% if (CurrentUser != null && EventPermission.Validate(null, CurrentUser, PermissionItemKeys.Instance().CreateEvent()))
               { %>
            <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ReleaseNewEvent", EventApplicationID), Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("NewEvent", "ChannelEvent")), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Add, TextIconLayout.IconText)%>
            <%} %>
        </div>
        <spb:BreadCrumb ID="BreadCrumb1" runat="server" />
    </div>
</div>
