﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<EventPhoto>" %>
<% int EventApplicationID = ApplicationIDs.Instance().Event();
   if (TempData["StatusMessageData"] != null)
   {
       StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Success, string.Empty));
       Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
       if (statusMessageData.MessageType == StatusMessageType.Success)
       {
           //关闭模式窗口
           Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
       }
       TempData["StatusMessageData"] = null;
   } %>

<form class="nyroModal" id="EditEventPhotoForm" action="<%=SPBUrlHelper.Action("UpdateEventPhoto","ChannelEvent",new RouteValueDictionary{{"attachmentID",ViewData.Model.AttachmentID}}) %>"
method="post">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Title_UpdatePhotoData", EventApplicationID)%> </h4>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_Name")%><%=GetResourceString("Common_Colon") %></label>
      <input name="friendlyFileName" type="text" class="tn-textbox tn-input-long tn-border-gray" value="<%=ViewData.Model.FriendlyFileName %>"
            id="friendlyFileName" />
    </div>
    <div class="tn-form-row tn-textarea-wrap">
      <label class="tn-form-label"> <%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></label>
      <textarea name="description" cols="45" rows="5" class="tn-textarea tn-input-long tn-border-gray" id="description"><%=Formatter.FormatMultiLinePlainTextForEdit(ViewData.Model.Description, true)%></textarea>
      <span style="display:none"></span>
    </div>
    <% if (EventPermission.Validate(ViewData.Model.EventID, Globals.GetCurrentUser(), PermissionItemKeys.Instance().EditEvent()))
       { %>
    <div class="tn-form-row">
      <label class="tn-form-label"> </label>
      <input name="featuredPhoto" type="checkbox" <% if (ViewData.GetBool("IsFeaturedPhoto", false)) Response.Write("checked=\"checked\""); %>
            class="radiobutton" id="featuredPhoto" value="<%=ViewData.Model.AttachmentID %>" />
      <label for="featuredPhoto"> <%=GetResourceString("Label_SetEventPhoto",EventApplicationID)%></label>
    </div>
    <%} %>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "onclick" ,"$.nyroModalRemove();"} })%> </div>
  </div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $("#EditEventPhotoForm").validate({
            rules: {
                friendlyFileName: { required: true, maxBlength: 64 },
                description: { maxBlength: 1024 }
            },
            messages: {
                friendlyFileName: { required: "<%=GetResourceString("Validate_InputPhotoName",EventApplicationID) %>", maxBlength: "<%=GetResourceString("Validate_MaxLengthFirst",EventApplicationID) %>" },
                description: { maxBlength: "<%=GetResourceString("Validate_PhotoDescriptionMaxLength",EventApplicationID) %>" }
            }
        });
        $("#saveButton").click(function() {
            if (!$("#EditEventPhotoForm").valid()) {
                return false;
            }
            else {
                $("#saveButton").attr('style', 'display:none');
                $("#saveButtonA").attr('style', 'display:inline');
            }
        });
    });
</script>
