﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<EventThread>" %>
<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
    SetExpireDays="30" />
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    EventThread eventThread = ViewData.Model;

    bool IsAdministrator = ViewData.GetBool("IsAdministrator", false);
    bool IsManager = ViewData.GetBool("IsManager", false);
    bool IsMember = ViewData.GetBool("IsMember", false);
    EventMember eventMember = ViewData.Get<EventMember>("eventMember", null);
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-event-panel">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <span class="tn-helper-right"><a href="<%=SiteUrls.Instance().ShowEvent(Model.EventID) %>">
            <%=GetResourceString("Action_ReturnEvent",EventApplicationID) %></a></span>
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_CanOperation",EventApplicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <%if (EventPermission.Validate(Model, CurrentUser, PermissionItemKeys.Instance().AdministerEvent()) || (CurrentUser != null && CurrentUser.UserID == Model.UserID))
          {%>
        <div class="tn-collapsible tn-collapsible-opend tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                <h4 class="tn-helper-reset">
                    <span>
                        <%=GetResourceString("Title_OperatingSponsors", EventApplicationID)%></span></h4>
                <span class="tn-icon tn-switch tn-icon-collapse-close"></span>
            </div>
            <div style="display: block;" class="tn-collapsible-content">
                <ul class="tn-side-menu">
                    <% if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().EditEvent()))
                       { %>
                    <li><span class="tn-icon tn-icon-update"></span><a href="<%=SPBUrlHelper.Action("EditEvent","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>"
                        class="tn-menu-text">
                        <%=GetResourceString("Action_UpdateEvent", EventApplicationID)%></a></li>
                    <%}
                       if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().ManageEventMembers()))
                       { %>
                    <li><span class="tn-icon tn-icon-user"></span><a href="<%=SPBUrlHelper.Action("ManageEventMembers","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>"
                        class="tn-menu-text">
                        <%=GetResourceString("Action_ManageEventMember", EventApplicationID)%></a></li>
                    <% }%>
                    <%--<li><span class="tn-icon tn-icon-user"></span><a href="<%=SPBUrlHelper.Action("EditEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID},{"number",ValueHelper.GetSqlMaxInt()}}) %>"
                        class="tn-menu-text">编辑活动照片</a></li>--%>
                    <li><span class="tn-icon tn-icon-email"></span><a id="massMessages" href="<%=SPBUrlHelper.Action("MassMessages", "ChannelEvent",new RouteValueDictionary {{"eventID",eventThread.EventID}})%>"
                        class="tn-menu-text">
                        <%=GetResourceString("Action_ClusterNotice",EventApplicationID) %></a></li>
                    <% if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().CancelEvent()) && eventThread.EventStatus == EventStatuses.Published)
                       { %>
                    <li><span class="tn-icon tn-icon-cross"></span><a class="tn-menu-text" href="javascript:;"
                        onclick="if (confirm('<%=GetResourceString("Message_ConfirmCancelEvent",EventApplicationID) %>')) { window.location.href='<%=SPBUrlHelper.Action("CancelEvent","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>'} ">
                        <%=GetResourceString("Action_CancelEvent", EventApplicationID)%></a></li>
                    <%} %>
                </ul>
            </div>
        </div>
        <%} %>
        <%if (CurrentUser != null && CurrentUser.IsContentAdministrator)
          {%>
        <div class="tn-collapsible tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                <h4 class="tn-helper-reset">
                    <span>
                        <%=GetResourceString("Title_OperatingSiteAdministrator",EventApplicationID)%></span></h4>
                <span class="tn-icon tn-switch tn-icon-collapse-close"></span>
            </div>
            <div style="display: block;" class="tn-collapsible-content">
                <ul class="tn-side-menu">
                    <li><span class="tn-icon tn-icon-elite"></span><a class="tn-menu-text" href="javascript:;"
                        id="setEssentialStatus" value="<% if(eventThread.IsEssential) Response.Write("true"); else Response.Write("false"); %>">
                        <% if (eventThread.IsEssential) Response.Write(GetResourceString("Action_CancelEssential", EventApplicationID)); else Response.Write(GetResourceString("Action_SetEssential", EventApplicationID)); %>
                    </a></li>
                    <li><span class="tn-icon tn-icon-flag"></span><a class="tn-menu-text" id="recommendEventModel"
                        href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Event(), eventThread.UserID, eventThread.EventID, eventThread.EventName) %>">
                        <%=GetResourceString("Common_ManagerRecommend")%></a></li>
                </ul>
            </div>
        </div>
        <%} %>
        <ul class="tn-side-menu">
            <%    if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().InviteFriendJoinEvent()))
                  { %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-user-invite">
            </span><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EventInvitation","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
                <%=GetResourceString("Action_InvitationFriend")%></a></li>
            <%} %>
            <% int UserID = CurrentUser != null ? CurrentUser.UserID : 0; %>
            <%if (eventThread.UserID != UserID && eventMember != null)
              {%>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-quit"></span>
                <a class="tn-menu-text" href="javascript:void()" onclick="if (confirm('<%=GetResourceString("Message_ConfirmExitEvent", EventApplicationID) %>')) { window.location.href='<%=SPBUrlHelper.Action("ExitEvent","ChannelEvent",new RouteValueDictionary{{"userID",UserID},{"eventID",eventThread.EventID}}) %>'} ">
                    <%=GetResourceString("Action_ExitEvent", EventApplicationID)%></a></li>
            <%} if (CurrentUser != null && EventPermission.Validate(eventThread, CurrentUser, PermissionItemKeys.Instance().UploadEventPhoto()))
              { %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-camera"></span>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("UploadEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
                    <%=GetResourceString("Action_OnloadPhoto", EventApplicationID)%></a> </li>
            <%} %>
            <% if (CurrentUser != null && EventPermission.ValidateSignUp(eventThread, CurrentUser))
               { %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-join"></span>
                <a class="tn-menu-text" name="signup" href="<%=SPBUrlHelper.Action("Control_EventSignUp","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>">
                    <%=GetResourceString("Action_SignUp", EventApplicationID)%></a> </li>
            <%} %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-bubble"></span>
                <a class="tn-menu-text" href="<%=SiteUrls.Instance().ShowEvent(eventThread.EventID) %>#comments">
                    <%=GetResourceString("Action_InputLeaveMessage", EventApplicationID)%></a>
            </li>
            <%if (CurrentUser == null)
              {
            %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-share"></span>
                <a class="tn-menu-text" href="<%=SiteUrls.Instance().Login(true) %>">
                    <%=GetResourceString("Common_Share", EventApplicationID)%></a> </li>
            <%} %>
            <% if (CurrentUser != null)
               {%>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-share"></span>
                <a class="tn-menu-text" id="shareLink" href="<%=SiteUrls.Instance().ShareInModal(true,WebUtils.FullPath(Request.RawUrl), eventThread.EventName,eventThread.Excerpt, SiteUrls.Instance().EventPhotoUrl(eventThread.FeaturedPhotoID,EventPhotoTypes.Logo), ApplicationIDs.Instance().Event(), eventThread.UserID, eventThread.Sponsor)%> ">
                    <%=GetResourceString("Common_Share", EventApplicationID)%></a> </li>
            <% if (!FavoriteManager.Instance(FavoriteItemKeys.Instance().EventThread()).IsFavorite(CurrentUser.UserID, Model.EventID))
               { %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-feed"></span>
                <a id="favirateButton1" href="<%=SPBUrlHelper.Action("Control_NewFavorite", "Channel", new RouteValueDictionary { { "favoriteItemName", WebUtils.UrlEncode(GetResourceString("Description_Event", EventApplicationID)) }, { "createFavoriteItemUrl", SPBUrlHelper.Action("CreateFavorite", "ChannelEvent", new RouteValueDictionary { { "eventID", Model.EventID } }) } }) %>"
                    class="tn-menu-text">
                    <%=GetResourceString("Action_Attention", EventApplicationID)%></a> </li>
            <%}
               else
               { %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-feed"></span>
                <a id="cancelfavorite1" href="<%=SPBUrlHelper.Action("DeleteFavorite", "ChannelEvent", new RouteValueDictionary { { "eventID", eventThread.EventID } })%>"
                    class="tn-menu-text">
                    <%=GetResourceString("Action_CancelAttention", EventApplicationID)%></a></li>
            <%} %>
            <%} %>
            <li class="tn-border-gray tn-border-bottom"><span class="tn-icon tn-icon-alert"></span>
                <a class="tn-menu-text" href="<%=SiteUrls.Instance().NewImpeachReport() %>" id="reportThisEvent">
                    <%=GetResourceString("Action_Report", EventApplicationID)%></a> </li>
        </ul>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
         $("#favirateButton1").dialog({id:"favirateDialog1",title:'<%=GetResourceString("Action_Attention",EventApplicationID) %>' });         
        $("#cancelfavorite1").click(function() {
            if (!confirm("<%=GetResourceString("Message_ConfirmCancelAttention",EventApplicationID) %>"))
                return false;
        });
    
    		$(".tn-collapsible").collapsibleBox();
        $('a[name="signup"]').nyroModal({
            resizeable: true
        });

        $('#recommendEventModel,#massMessages').nyroModal({
            resizeable: true,
            height: 450,
            width: 400
        });

        $('#shareLink').nyroModal({
                resizeable: true,
                width:500
        });
        
        $('#reportThisEvent').nyroModal({
            resizeable: true
        });
        $("#setEssentialStatus").click(function() {
            var IsEssential = eval($("#setEssentialStatus").attr("value"));
            $.getJSON('<%=SPBUrlHelper.Action("UpdateEssentialStatus","ChannelEvent",new RouteValueDictionary{{"eventID",eventThread.EventID}}) %>', { isEssential: !IsEssential }, function(data) {
                if (data == null)
                    return;
                if (data != IsEssential) {
                    if (data)
                        $("#setEssentialStatus").text("<%=GetResourceString("Message_AlreadySetEssentialEvent", EventApplicationID) %>");
                    else
                        $("#setEssentialStatus").text("<%=GetResourceString("Message_AlreadyCancelSetEssential", EventApplicationID) %>");
                    setTimeout(function() {
                        $("#setEssentialStatus").attr("value", data);
                        if (data)
                            $("#setEssentialStatus").text("<%=GetResourceString("Message_CancelSetEssential", EventApplicationID) %>");
                        else
                            $("#setEssentialStatus").text("<%=GetResourceString("Message_SetEssential", EventApplicationID) %>");
                    }, 2000);
                }
            });
        });
    });
</script>
