﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<EventThread>" %>
<%EventThread thread = ViewData.Model;
  int   eventApplicationID=ApplicationIDs.Instance().Event(); %>
  <div class="tn-card tn-card-complete tn-widget-content">
      <div class="tn-showcase tn-helper-clearfix">        
        <div class="tn-info">
            <div class="tn-id-name">
                <strong> <a href="<%=SPBUrlHelper.Action("ShowEvent", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>">
                    <%=StringUtils.Trim( thread.EventName ,21)%></a></strong></div>           
            <div class="tn-info-part">
                <dl class="tn-text-note">
                    <dt>
                       <%=GetResourceString("Label_Time", eventApplicationID)%><%=GetResourceString("Common_Colon")%></dt>
                    <dd>
                       <%=Formatter.FormatDate(thread.DateCreated) %></dd>
                </dl>               
            
                <dl >
                    <dt class="tn-text-note">
                       <%=GetResourceString("Label_Place", eventApplicationID)%><%=GetResourceString("Common_Colon")%>
                    </dt>
                    <dd>
                       <a href="<%=SiteUrls.Instance().ListEventsByAreaCode(thread.AreaCode) %>"><%=Formatter.FormatArea(thread.AreaCode,1,2) %></a>
                    </dd>
                </dl>               
            
                <dl >
                    <dt class="tn-text-note">
                      <%=GetResourceString("Label_ReleaseUser", eventApplicationID)%><%=GetResourceString("Common_Colon")%>
                    </dt>
                    <dd>
                      <a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,eventApplicationID)%>"><%=thread.Sponsor%></a>
                    </dd>
                </dl>       
           
                <dl class="tn-text-note">
                    <dt> <%=thread.MemberCount %><%=GetResourceString("Label_Attend", eventApplicationID)%>
                        <%=thread.FaviteCount %><%=GetResourceString("Label_Attention", eventApplicationID)%>
                        <%=thread.HitTimes %><%=GetResourceString("Label_Scan", eventApplicationID)%>   </dt>
                   
                </dl> 
                 <dl class="tn-id-name">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>"><%=thread.PhotoCount%><%=GetResourceString("Label_Photos", eventApplicationID)%></a> 
                    <a class="tn-action-text" href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>#comments"><%=thread.PostCount%><%=GetResourceString("Label_Messages", eventApplicationID)%></a> 
                </dl> 
                       
            </div>
        </div>
    </div>
      <div class="tn-actions tn-bg-light tn-border-light tn-border-top">          
          <span class="tn-button tn-button-default"><span class="tn-first-child"><a class="tn-button-text addFriendModal" href="<%=SPBUrlHelper.Action("ShowEvent", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>"><%= GetResourceString("Action_ParticularIntroduce", eventApplicationID)%></a> </span></span>
         
          <span class="tn-button tn-button-default"><span class="tn-first-child"><a class="tn-button-text" href="<%=SPBUrlHelper.Action("ListEventPhotos","ChannelEvent",new RouteValueDictionary{{"eventID",thread.EventID}}) %>"><%=GetResourceString("Description_EventPhotos", eventApplicationID)%></a> </span></span>
          
</div>
  </div>