﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<Invitation>>" %>
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    int UserApplicationID = ApplicationIDs.Instance().User();
    IList<Invitation> invitations = Model;
    StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
    if (statusMessageData != null)
    {
        if (statusMessageData.MessageType == StatusMessageType.Success)
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 3000, false));
        //else
        //    Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData,true));
        statusMessageData = null;
    }
    if (invitations.Count > 0)
    {
        Dictionary<int, PersonUser> personUsers = ViewData.Get<Dictionary<int, PersonUser>>("personUsers", new Dictionary<int, PersonUser>()); %>
<div id="EventInvitationOutBox">
    <ul class="tn-list tn-helper-reset">
        <% foreach (Invitation invitation in invitations)
           {
               PersonUser pu = personUsers[invitation.ReceiverUserID];
               int returnToPageIndex = 1;//删除成员后需返回的页序

               string deleteOutBoxInvitationUrl = SPBUrlHelper.Action("DeleteOutBoxInvitation", "ChannelEvent", new RouteValueDictionary { { "invitationID", invitation.InvitationID }, { "eventID", invitation.RelativeItemID }, { "pageIndex", returnToPageIndex } });
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(pu.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%></div>
            </div>
            <div class="tn-list-item-area-right">
                <ul class="tn-list-actions tn-helper-reset">
                    <li class="tn-list-action tn-border-gray tn-border-bottom"><%if (CurrentUser != null)
                                                                                 { %> <a href="<%=SiteUrls.Instance().NewMessage(CurrentUser.UserName,pu.UserID) %>">
                        <%= GetResourceString("Action_SendPrivateMessage")%></a><%} %></li>
                    <li class="tn-list-action tn-border-gray tn-border-bottom"><a href="javascript:;"
                        onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeleteInvite",EventApplicationID) %>'))
                             $('#EventInvitationOutBox').parent().load('<%=deleteOutBoxInvitationUrl %>');">
                        <%=GetResourceString("Action_Delete")%></a></li>
                </ul>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset">
                        <a href="<%=SiteUrls.Instance().UserDomainHome((User)pu) %>" target="_blank">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(pu)%></a></h5>
                </div>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserGender",UserApplicationID) %><%=GetResourceString("Common_Colon") %><%switch (pu.Gender)
                                                                                                                                    {
                                                                                                                                        case Genders.Female:
                                                                                                                                            Response.Write(GetResourceString("Enum_Genders_Female"));
                                                                                                                                            break;
                                                                                                                                        case Genders.Male:
                                                                                                                                            Response.Write(GetResourceString("Enum_Genders_Male"));
                                                                                                                                            break;
                                                                                                                                        default:
                                                                                                                                            Response.Write(GetResourceString("Common_NotSet"));
                                                                                                                                            break;
                                                                                                                                    }%>
                    </em></cite>
                </div>
                <% if (!string.IsNullOrEmpty(pu.CompanyName))
                   { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">E-mail：<%=pu.PublicEmail %></em></cite>
                </div>
                <% 
                    }
                   if (!string.IsNullOrEmpty(pu.CompanyName))
                   { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserMobile", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=pu.Mobile %></em></cite>
                </div>
                <% 
                    }
                       if (!string.IsNullOrEmpty(pu.CompanyName))
                       { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserTel", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=pu.HomeTel %></em></cite>
                </div>
                <%} %>
                <% if (!string.IsNullOrEmpty(pu.CompanyName))
                   { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserCompany", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=pu.HomeTel %><%=GetResourceString("Common_Colon") %><%=pu.CompanyName%></em></cite>
                </div>
                <%}
                   if (!string.IsNullOrEmpty(pu.Title))
                   { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserJob", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=pu.Title%></em></cite>
                </div>
                <%}
                       if (!string.IsNullOrEmpty(pu.PersonAddress))
                       { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserAddress", UserApplicationID)%><%=GetResourceString("Common_Colon") %><%=pu.PersonAddress%></em></cite>
                </div>
                <%}%>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_Status") %><%=GetResourceString("Common_Colon") %><% switch (invitation.Status)
                                                                                                         {
                                                                                                             case InvitationStatuses.Accept:
                                                                                                                 Response.Write(GetResourceString("Lable_Accepted"));
                                                                                                                 break;
                                                                                                             case InvitationStatuses.Refuse:
                                                                                                                 Response.Write(GetResourceString("Lable_Ignored"));
                                                                                                                 break;
                                                                                                             case InvitationStatuses.Unsettled:
                                                                                                                 Response.Write(GetResourceString("Label_NotDisposed"));
                                                                                                                 break;
                                                                                                             default:
                                                                                                                 break;
                                                                                                         } %>
                    </em></cite>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
</div>
<%} %>
