﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    int EventApplicationID = ApplicationIDs.Instance().Event();
    int UserApplicationID = ApplicationIDs.Instance().User();
    EventThread thread = EventThreads.GetEvent(ViewData.GetInt("EventID", 0), false);
    int SurplusCount = ViewData.GetInt("SurplusCount");
    SurplusCount = SurplusCount > 0 ? SurplusCount + 1 : 99999999;
    if (TempData["StatusMessageType"] != null || ViewData["StatusMessageType"] != null)
    {
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
            if (messageType != StatusMessageType.Error)
            {
                //关闭模式窗口
                Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
            }
            TempData["StatusMessageType"] = null;
            
        }
        else
        {
            StatusMessageType messageType = (StatusMessageType)ViewData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, ViewData.GetString("StatusMessageContent", string.Empty), false));
            ViewData["StatusMessageType"] = null;

        }
    }
    else
    {
   
%>
<% if (CurrentUser != null)
   {
       PersonUser pu = CurrentUser as PersonUser;
       if (pu == null)
           pu = new PersonUser();
       EventMember member = ViewData.Get<EventMember>("member", null);
      

%>

<form id="registeredUserSignUpForm" name="registeredUserSignUpForm" action="<%=SPBUrlHelper.Action("RegisteredUserSignUp","ChannelEvent",new RouteValueDictionary{{"eventID",ViewData.GetInt("EventID", 0)}}) %>"
method="post" class="nyroModal">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Title_EventSignUp", EventApplicationID)%> </h4>
    <div class="tn-form-row">
      <label class="tn-form-label" for="email"> E-mail：</label>
      <input name="email" type="text" class="tn-textbox tn-input-long tn-border-gray" id="email"
            value="<%if (member != null && !string.IsNullOrEmpty(member.Email)) Response.Write(member.Email); else Response.Write(pu.PublicEmail); %>" />
      <span class="tn-form-required"> <%=GetResourceString("Description_Required")%></span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="moblie"> <%=GetResourceString("Label_PersonUserMobile", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="moblie" type="text" class="tn-textbox tn-input-long tn-border-gray"
            value="<%if (member != null && !string.IsNullOrEmpty(member.Moblie)) Response.Write(member.Moblie); else Response.Write(pu.Mobile); %>"
            id="moblie" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="telephone"> <%=GetResourceString("Label_PersonUserTel", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="telephone" type="text" class="tn-textbox tn-input-long tn-border-gray"
            value="<%if (member != null && !string.IsNullOrEmpty(member.Telephone)) Response.Write(member.Telephone); else Response.Write(pu.HomeTel); %>"
            id="telephone" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="body"> <%=GetResourceString("Label_ApplyLeaveMessage", EventApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <textarea name="body" cols="45" rows="5" class="tn-textarea tn-input-long tn-border-gray"
            id="body"></textarea>
      <span class="tn-form-required"> <%=GetResourceString("Description_Required")%></span>
      <div class="tn-text-note"> <%=GetResourceString("Description_EventOrganise", EventApplicationID)%></div>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="bringCount"> <%=GetResourceString("Label_CarryNumber", EventApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input type="text" id="bringCount" name="bringCount" value="0" class="tn-textbox tn-input-short tn-border-gray" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="remark"> <%=GetResourceString("Label_Annotations", EventApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input type="text" id="remark" name="remark" class="tn-textbox tn-input-long tn-border-gray" />
      <div class="tn-text-note"> <%=GetResourceString("Description_SupplyExplain", EventApplicationID)%></div>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("registeredUserSignUpSubmit", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "onclick", "$.nyroModalRemove();" } })%> </div>
  </div>
</form>


<script type="text/javascript" rel="forceLoad">
        
        $(document).ready(function() {
            $("#registeredUserSignUpForm").validate({
                rules: {
                bringCount:{digits: true,max:<%=SurplusCount%>},
                <%if(thread.IsAuditingSigner){ %>
  body: { required: true, maxBlength: 256 },
<%} %>
                  
                    email: { required: true, email: true },
                    telephone: { minlength: 4, maxlength: 15 },
                    moblie: { digits: true, minlength: 11, maxlength: 20 }
                },
                messages: {
                bringCount:{digits:"<%=GetResourceString("Validate_InputNumber",EventApplicationID) %>",max:"您带的人数超限了"},
                <%if(thread.IsAuditingSigner){ %>
                body: { required: "<%=GetResourceString("Validate_InputLeaveMessageBody",EventApplicationID) %>", maxBlength: "<%=GetResourceString("Validate_LeaveMessageMaxLength",EventApplicationID) %>" },
<%} %>
                email: { required: "<%=GetResourceString("Validate_PrivateEmailRequired", UserApplicationID)%>", email: "<%=GetResourceString("Validate_PrivateEmailStyle", UserApplicationID)%>" },
                telephone: { minBlength: "<%=GetResourceString("Validate_LinkTelMinlength", UserApplicationID)%>", maxlength: "<%=GetResourceString("Validate_LinkTelMaxlength", UserApplicationID)%>" },
                moblie: { digits: "<%=GetResourceString("Validate_LinkTelDigits", UserApplicationID)%>", minlength: "<%=GetResourceString("Validate_MobileMinlength", UserApplicationID)%>", maxlength: "<%=GetResourceString("Validate_MobileMaxlength", UserApplicationID)%>" }

                }
            });
            $("#registeredUserSignUpSubmit").click(function() {
                if (!$("#registeredUserSignUpForm").valid()) {
                    return false;
                }
            });
        });
</script>
<%}
   else if (thread.IsAllowAnonymousUserSignUp)
   { %>
<form id="anonymousSignUpForm" name="anonymousSignUpForm" action="<%=SPBUrlHelper.Action("anonymousSignUp","ChannelEvent",new RouteValueDictionary{{"eventID",ViewData.GetInt("EventID",0)}}) %>"
method="post" class="tn-helper-reset nyroModal">
  <div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom"> <%=GetResourceString("Title_EventSignUp", EventApplicationID)%> </h4>
    <div class="tn-text-note"> <%=GetResourceString("Description_AnonymousApplyCondition", EventApplicationID)%></div>
    <br />
    <div class="tn-form-row">
      <label class="tn-form-label" for="displayName"> <%=GetResourceString("Label_CommonName")%><%=GetResourceString("Common_Colon")%></label>
      <input name="displayName" type="text" class="tn-textbox tn-input-long tn-border-gray"
            id="displayName" />
      <span class="tn-form-required"> <%=GetResourceString("Description_Required")%></span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label"> <%=GetResourceString("Label_PersonUserGender", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <% Dictionary<int, CodeItem> Genders = CodeItems.GetCodeItems(CodeSetCodes.Instance().Gender()); %>
      <%=SPBHtmlHelper.Instance().ShowRadioButtonList<int, string>("gender", Genders.ToDictionary(n => n.Key, n => n.Value.Name), new RouteValueDictionary { { "class", "dropDownList" } }, 1)%> </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="email"> E-mail：</label>
      <input name="email" type="text" class="tn-textbox tn-input-long tn-border-gray" id="email"
            style="width: 270px" />
      <span class="tn-form-required"> <%=GetResourceString("Description_Required")%></span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="moblie"> <%=GetResourceString("Label_PersonUserMobile", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="moblie" type="text" class="tn-textbox tn-input-long tn-border-gray"
            id="moblie" />
      <span class="tn-form-required"> <%=GetResourceString("Description_Required")%></span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="telephone"> <%=GetResourceString("Label_PersonUserTel", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="telephone" type="text" class="tn-textbox tn-input-long tn-border-gray"
            id="telephone" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="company"> <%=GetResourceString("Label_PersonUserCompany", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="company" type="text" class="tn-textbox tn-input-long tn-border-gray"
            id="company" style="width: 270px" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="job"> <%=GetResourceString("Label_PersonUserJob", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="job" type="text" class="tn-textbox tn-input-long tn-border-gray" id="job"
            style="width: 270px" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="address"> <%=GetResourceString("Label_PersonUserAddress", UserApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input name="address" type="text" class="tn-textbox tn-input-long tn-border-gray"
            id="address" style="width: 270px" />
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="requestBody"> <%=GetResourceString("Label_ApplyLeaveMessage", EventApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <textarea name="requestBody" cols="45" rows="5" class="tn-textarea tn-input-long tn-border-gray"
            id="requestBody"></textarea>
      <span class="tn-form-required"> <%=GetResourceString("Description_Required")%></span>
      <div class="tn-text-note"> <%=GetResourceString("Description_EventOrganise", EventApplicationID)%></div>
    </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="eventbringCount"> 携带人数<%=GetResourceString("Common_Colon")%></label>
      <input type="text" id="eventbringCount" name="eventbringCount" class="tn-textbox tn-input-short tn-border-gray"
            style="width: 270px" />
      <span class="tn-text-note">不携带，请留空</span> </div>
    <div class="tn-form-row">
      <label class="tn-form-label" for="remark"> <%=GetResourceString("Label_Annotations", EventApplicationID)%><%=GetResourceString("Common_Colon")%></label>
      <input type="text" id="remark" name="remark" class="tn-textbox tn-input-long tn-border-gray"
            style="width: 270px" />
      <div class="tn-text-note"> <%=GetResourceString("Description_SupplyExplain", EventApplicationID)%></div>
    </div>
    <div class="tn-form-row tn-form-row-button">
      <label class="tn-form-label"> </label>
      <%=SPBHtmlHelper.Instance().SubmitButton("anonymousSignUp", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%> <%=SPBHtmlHelper.Instance().CancelButton(new RouteValueDictionary { { "onclick", "$.nyroModalRemove();" } })%> </div>
  </div>
</form>
<script type="text/javascript" rel="forceLoad">

        $(document).ready(function() {
            $("#anonymousSignUpForm").validate({
                rules: {
                    displayName: { required: true, maxBlength: 10 },
                    email: { required: true, email: true },
                    telephone: { rangelength: [4, 15] },
                    moblie: { required: true, digits: true, minlength: 11, maxlength: 20 },
                    company: { maxBlength: 20 },
                    eventbringCount:{digits: true,max:<%=SurplusCount%>},
                    job: { maxBlength: 20 },
                    address: { maxBlength: 50 },
                    requestBody: { required: true, maxBlength: 256 }
                },
                messages: {
                    displayName: { required: "<%=GetResourceString("Validate_InputName", EventApplicationID) %>", maxBlength: "<%=GetResourceString("Validate_MaxLengthSecond", EventApplicationID) %>" },
                    email: { required: "<%=GetResourceString("Validate_InputEmailAddress", EventApplicationID) %>", email: "<%=GetResourceString("Validate_InputFormatError", EventApplicationID) %>" },
                    telephone: { rangelength: "<%=GetResourceString("Validate_TelNumberMaxLength", EventApplicationID) %>" },
                    moblie: { required: "<%=GetResourceString("Validate_InputMobileNumber", EventApplicationID) %>", digits: "<%=GetResourceString("Validate_InputNumber", EventApplicationID) %>", minBlength: "<%=GetResourceString("Validate_MobileNumberMin", EventApplicationID) %>", maxBlength: "<%=GetResourceString("Validate_MobileNumberMax", EventApplicationID) %>" },
                    company: { maxBlength: "<%=GetResourceString("Validate_CompanyNameMax", EventApplicationID) %>" },
                    eventbringCount:{digits:"<%=GetResourceString("Validate_InputNumber",EventApplicationID) %>",max:"您带的人数超限了"},
                    job: { maxBlength: "<%=GetResourceString("Validate_JobStringLengthMax", EventApplicationID) %>" },
                    address: { maxBlength: "<%=GetResourceString("Validate_AddressStringLengthMax", EventApplicationID) %>" },
                    requestBody: { required: "<%=GetResourceString("Validate_InputLeaveMessageBody", EventApplicationID) %>", maxBlength: "<%=GetResourceString("Validate_LeaveMessageMaxLength", EventApplicationID) %>" }
                }
            });
            $("#anonymousSignUp").click(function() {
                if (!$("#anonymousSignUpForm").valid()) {
                    return false;
                }
            });
        });
</script>
<%}
    }
%>
