﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<Favorite>>" %>
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
       TempData["StatusMessageType"] = null;
   }
   int EventApplicationID = ApplicationIDs.Instance().Event();
   int UserApplicationID = ApplicationIDs.Instance().User();
   int eventID = Html.GetParameterFromRouteDateOrQueryString<int>("eventID");

%>
<div id="listEventAttentionMembers">
    <ul class="tn-list tn-helper-reset">
        <% 
        
            foreach (Favorite member in ViewData.Model.Records)
            {
                PersonUser personUser = Users.GetUser(member.UserID, false) as PersonUser;
                if (personUser == null)
                    continue;
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(member.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%></div>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset">
                        <% if (member.UserID > 0)
                           { %>
                        <a target="_blank" href="<%=SiteUrls.Instance().UserDomainHome(member.UserID) %>">
                           <%=SPBHtmlHelper.Instance().UserDisplayName(member.UserID,true)%></a>
                        <%}
                           else Response.Write(member.DisplayName); %>
                        <a href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",personUser.UserName}}) %>">
                            <%=SPBHtmlHelper.Instance().ShowUserRankIcons(personUser)%></a>
                    </h5>
                </div>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserGender",UserApplicationID)%><%=GetResourceString("Common_Colon") %></em><%if (personUser.Gender == Genders.Female) Response.Write(GetResourceString("Enum_Genders_Female")); else Response.Write(GetResourceString("Enum_Genders_Male")); %></em></cite>
                </div>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_Place", ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon") %></em></cite><a
                            href="<%=SiteUrls.Instance().ListEventsByAreaCode(personUser.HomeAreaCode) %>"><%=Formatter.FormatArea(personUser.HomeAreaCode,true)%></a>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Controls_ListEventAttentionMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>

    <script type="text/javascript">
        function pageIndexChange(url) {
            $('#listEventAttentionMembers').parent().load(url);
        }         
    
        
    </script>

</div>
