﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventMember>>" %>
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
       TempData["StatusMessageType"] = null;
   }
   int EventApplicationID = ApplicationIDs.Instance().Event();
   int UserApplicationID = ApplicationIDs.Instance().User();
   int eventID = Html.GetParameterFromRouteDateOrQueryString<int>("eventID");
%>
<div id="Main">
    <div class="tn-list-header">
        <form id="ManageSearchForm" method="get" action="">
        <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-search-box tn-helper-right">
                <input name="displayNameKeyWord" id="displayNameKeyWord" type="text" class="tn-search-input tn-input-medium tn-border-gray tn-border-tbl"
                    value="<%=Html.GetParameterFromRouteDateOrQueryString("displayNameKeyWord") %>">
                <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                    <button onclick="$('#ManageSearchForm').submit();">
                        <span class="tn-icon tn-icon-find"></span>
                    </button>
                </span>
            </div>
            <%--<span class="tn-button tn-button-text-icon tn-button-primary"><span class="tn-first-child"><span class="tn-icon tn-icon-user-invite"></span><a href="#" class="tn-button-text">邀请好友加?/a> </span></span>--%>
        </div>
        </form>
    </div>
    <ul class="tn-list tn-helper-reset">
        <% 
            
            foreach (EventMember member in ViewData.Model.Records)
            {
                PersonUser personUser = Users.GetUser(member.UserID, false) as PersonUser;
                if (personUser == null)
                    continue;                   
        %>
        <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
            <div class="tn-list-item-area-left">
                <div class="tn-avatar">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(member.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%></div>
            </div>
            <div class="tn-list-item-area-main">
                <div class="tn-list-item-row tn-list-item-heading">
                    <h5 class="tn-helper-reset">
                        <% if (member.UserID > 0)
                           { %>
                        <a target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(member.UserID,UserDomainSpecialAppIDs.Instance().Home()) %>">
                            <%=SPBHtmlHelper.Instance().UserDisplayName(member.UserID,true)%></a> <a href="<%=SPBUrlHelper.Action("TotalUserPoints","MessageCenter",new RouteValueDictionary{{"userDomainName",personUser.UserName}}) %>">
                                <%=SPBHtmlHelper.Instance().ShowUserRankIcons(personUser)%></a>
                        <%}
                           else Response.Write(member.DisplayName); %>
                    </h5>
                </div>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_PersonUserGender",UserApplicationID)%><%=GetResourceString("Common_Colon") %><%if (member.Gender == Genders.Female) Response.Write(GetResourceString("Enum_Genders_Female")); else Response.Write(GetResourceString("Enum_Genders_Male")); %></em></cite>
                </div>
                <%if (member.BringCount > 0)
                  { %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note">
                        <%=GetResourceString("Label_CarryNumber",EventApplicationID) %><%=GetResourceString("Common_Colon") %>
                        <%=member.BringCount %>
                    </cite>
                </div>
                <%} %>
                <div class="tn-list-item-row">
                    <cite class="tn-text-note"><em class="tn-date">
                        <%=GetResourceString("Label_Place", ApplicationIDs.Instance().Event())%><%=GetResourceString("Common_Colon") %></em></cite><a
                            href="<%=SiteUrls.Instance().ListEventsByAreaCode(personUser.HomeAreaCode) %>"><%=Formatter.FormatArea(personUser.HomeAreaCode,true)%></a>
                </div>
            </div>
        </li>
        <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
        <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Controls_ListEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
        <div class="tn-page-results tn-text-note">
            <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
</div>

<script type="text/javascript">     
  function pageIndexChange(url) {
            $('#Main').parent().load(url);
        }         
     $(document).ready(function() {
      if(!$("#displayNameKeyWord").val())
       $("#displayNameKeyWord").watermark('<%=GetResourceString("Lable_PleaseInputKeyword") %>');
   


             $("#ManageSearchForm").submit(function() {
             $('#ManageSearchForm').ajaxSubmit(
             {
                 target: '#Main',
                 url: '<%=SPBUrlHelper.Action("Controls_ListEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID",eventID }, {"pageIndex",Html.GetParameterFromRouteDateOrQueryString("pageIndex",0)} })%>'
             });
                 return false;
             });
             
    });
        
</script>

