﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventPhotoComment>>" %>
<% 
    int EventApplicationID = ApplicationIDs.Instance().Event();
    
    bool hasManagePermission = ViewData.GetBool("hasManagePermission", false);
    bool hasCreatePermission = ViewData.GetBool("hasCreatePermission", false);
    int eventID = ViewData.GetInt("eventID", -1);
    int returnToPageIndex = ViewData.Model.PageIndex;
    int pageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * (returnToPageIndex - 1) + 1)
    {
        returnToPageIndex = ViewData.Model.PageIndex - 1;
    }
    int addCommentPageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageSize * addCommentPageIndex)
        addCommentPageIndex = addCommentPageIndex + 1;
    int maxLengthPerReply = EventConfiguration.Instance().MaxLengthPerReply;
    int attachmentID = ViewData.GetInt("attachmentID", 0);
%>
<div id="PhotoCommentsAndComment">
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), 2000, false));
            }
            else
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.Get<string>("StatusMessageContent"), false));
            }
            TempData["StatusMessageType"] = null;
        }
        if (hasCreatePermission)
        {%>
    <form id="photoCommentsForm" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("CreateEventPhotoComment","ChannelEvent",new RouteValueDictionary {{"attachmentID",attachmentID},{"pageIndex",addCommentPageIndex}}) %>"
    method="post">
    <div class="tn-form">
        <div class="tn-comment-form-wrap tn-emotion-box tn-bg-gray">
            <div class="tn-comment-form">
                <a name="Comment"></a>
 
                <div class="tn-comment-form tn-emotion-box">
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "body"));%>
                    <div class="tn-comment-text-wrap tn-border-gray tn-form-row-near tn-textarea-wrap">
                        <textarea class="tn-comment-text-area" rows="5" cols="60" name="body" id="body"><%=TempData.GetString("body",string.Empty) %></textarea><br />
                        <span style="display:none"></span>
                    </div>
                    <div class="tn-form-row tn-text-note">
                        <%=string.Format(GetResourceString("Description_Pattern_WordCountLimit"), maxLengthPerReply)%></div>
                </div>
                <% SiteSettings settings = SiteSettingsManager.GetSiteSettings();
                   if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
                   {%>
                <div class="tn-form-row tn-form-row-verifycode">
                    <label>
                        <%=GetResourceString("Label_VerifyCode")%><%=GetResourceString("Common_Colon") %></label>
                    <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%>
                </div>
                <%} %>
                <div class="tn-form-row tn-form-row-button">
                    <label class="tn-form-label">
                        &nbsp;</label>
                    <%=SPBHtmlHelper.Instance().SubmitButton("createComment", GetResourceString("Button_Submit"))%>
                    <% if (Request.UrlReferrer != null)
                       {%>
                    <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri)%>
                    <%} %>
                </div>
            </div>
        </div>
    </div>
    </form>
    <%} %>
    <%if (Model != null && Model.Records.Count > 0)
      {%>
    <div id="photoCommentsListDiv" class="tn-comment-wrap">
        <div class="tn-list-header">
            <div class="tn-text-heading tn-border-bottom tn-border-gray">
                <%--<h4>
                    留言评论<span class="tn-text-note"><%event %></span></h4>--%>
            </div>
            <ul class="tn-comments tn-helper-reset">
                <% foreach (EventPhotoComment photoComment in Model.Records)
                   {%>
                <li class="tn-comment-item tn-border-gray tn-border-bottom">
                    <div class="tn-comment tn-helper-clearfix">
                        <div class="tn-comment-avatar">
                            <div class="tn-avatar">
                                <%=SPBHtmlHelper.Instance().ShowUserAvatar(photoComment.UserID,true,HyperLinkTarget._blank, AvatarSizeTypes.Small,new RouteValueDictionary {{"class","tn-round-corner"}})%>
                            </div>
                        </div>
                        <% if (hasManagePermission || (CurrentUser != null && (photoComment.UserID == CurrentUser.UserID)))
                           {%>
                        <a class="tn-icon tn-icon-cross tn-helper-right" onclick="if (confirm('<%=GetResourceString("Message_ConfirmDeletePhotoComment",EventApplicationID) %>')) { $('#PhotoCommentsAndComment').load('<%=SPBUrlHelper.Action("DeleteEventPhotoComment","ChannelEvent",new RouteValueDictionary {{"eventID",eventID}, {"commentID",photoComment.CommentID},{"pageIndex",returnToPageIndex}}) %>' )}">
                        </a>
                        <%} %>
                        <div class="tn-comment-info">
                            <div class="tn-commentator">
                                <h5>
                                    <%=SPBHtmlHelper.Instance().UserDisplayNameLink(photoComment.UserID,photoComment.Author)%>
                                </h5>
                                <em class="tn-text-note tn-date">
                                    <%=Formatter.FormatDate(photoComment.DateCreated,true) %></em></div>
                            <p>
                                <%=photoComment.Body%></p>
                        </div>
                    </div>
                </li>
                <%} %>
                <div class="tn-pagination tn-helper-align-center">
                    <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, pageIndex, 11, SPBUrlHelper.Action("Control_ListEventPhotoComments", "ChannelEvent", new RouteValueDictionary { { "attachmentID", Request.QueryString.GetInt("attachmentID", 0) }, { "pageIndex", "{0}" } }))%>
                </div>
            </ul>
        </div>
    </div>
    <% }%>

    <script type="text/javascript">

        $(document).ready(function() {
            $("#photoCommentsForm").validate({
                rules: {
                    body: { required: true, rangelength: [1, <%=maxLengthPerReply %>] },
                    verifyCode:{required: true}
                },
                messages: {
                    body: { required: "<%=GetResourceString("Validate_FillInCommentBody")%>", rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_CommentBodyMaxLength"),maxLengthPerReply)%>" },
                    verifyCode:{required: "<%=GetResourceString("Validate_FillInValidate")%>"}
                }
            });
            $('.nyroModal').nyroModal({
                resizeable: true
            });

        $('#photoCommentsForm').ajaxForm({
            beforeSubmit: function() {
                if (!$("#photoCommentsForm").valid())
                { return false; }
                $('#photoCommentsForm').block({
                    message: '<%=GetResourceString("Message_Loading")%>'
                });
            },
            target: '#PhotoCommentsAndComment',
            success: function() {
                $('#photoCommentsForm').unblock();
            }
        });
    });
    </script>

</div>
