﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<EventPhoto>>" %>
<% if (TempData["StatusMessageType"] != null)
   {
       StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
       if (messageType == StatusMessageType.Success)
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2000, false));
       else
           Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));
       TempData["StatusMessageType"] = null;
   }
   int eventID = ViewData.GetInt("EventID", 0);
   int EventApplicationID = ApplicationIDs.Instance().Event();
%>

<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-photos-main spb-event-photos">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom"> <span class="tn-helper-right">
    <%if (CurrentUser != null && EventPermission.Validate(eventID, CurrentUser, PermissionItemKeys.Instance().UploadEventPhoto()))
              { %>
    <a href="<%=SPBUrlHelper.Action("UploadEventPhotos", "ChannelEvent", new RouteValueDictionary {{"eventID",eventID} })%>"> <%=GetResourceString("Action_OnloadPhoto", EventApplicationID)%></a>
    <%} %>
    </span>
    <h3 class="tn-helper-reset"> <%=string.Format(GetResourceString("Title_Pattern_SomebodyPhoto",EventApplicationID),ViewData.GetString("EventName",string.Empty))%> </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <ul class="tn-photo-list tn-widget tn-helper-clearfix">
      <%
                int totalCount = ViewData.Model.TotalRecords;
                foreach (EventPhoto photo in ViewData.Model.Records)
                { 
            %>
      <li class="tn-photo-item">
        <p class="tn-photo-wrap tn-widget-content tn-border-gray"> <a href="<%=SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID) %>"> <img src="<%=SiteUrls.Instance().EventPhotoUrl(photo.AttachmentID, EventPhotoTypes.Thumbnail) %>"
                            title="<%=photo.FriendlyFileName %>" /><span></span></a> </p>
        <p class="tn-text-heading"> <a href="<%=SiteUrls.Instance().ShowEventPhoto(photo.AttachmentID) %>"> <%= StringUtils.Trim(photo.FriendlyFileName,10) %></a> </p>
      </li>
      <%} %>
    </ul>
    <div class="tn-pagination tn-helper-align-center">
      <% string pagingActionUrl = SPBUrlHelper.Action("Control_ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "pageIndex", "{0}" } });
               if (eventID > 0)
                   pagingActionUrl = SPBUrlHelper.Action("Control_ListEventPhotos", "ChannelEvent", new RouteValueDictionary { { "eventID", eventID }, { "pageIndex", "{0}" } });
            %>
      <%=SPBHtmlHelper.Instance().AjaxPagingButton(ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7,
                                                                           pagingActionUrl, "pageIndexChange()")%>
      <div class="tn-page-results tn-text-note"> <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
    </div>
  </div>
  <script type="text/javascript">
        function pageIndexChange(url) {
            $('#ListEventPhotos').parent().load(url);
        }
    </script>
</div>
